package com.artfess.data.dto;

import com.artfess.data.model.BizUserWorkDetail;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
@ApiModel(value="EditPersonalProfileDto对象", description="修改个人档案")
public class EditPersonalProfileDto {

    @ApiModelProperty(value = "系统人员ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "个人档案编号（唯一值）")
    @TableField("user_archive_")
    private String userArchive;

    @ApiModelProperty(value = "建档单位名称")
    @TableField("archive_unit_name_")
    private String archiveUnitName;

    @ApiModelProperty(value = "建档年月（格式：2024年12月）")
    @TableField("archive_year_")
    private LocalDate archiveYear;

    @ApiModelProperty(value = "人员档案姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "性别")
    @TableField("sex_")
    private String sex;

    @ApiModelProperty(value = "身份证号")
    @TableField("ident_card_")
    private String identCard;

    @ApiModelProperty(value = "电话号码")
    @TableField("phone_num_")
    private String phoneNum;

    @ApiModelProperty(value = "出生日期")
    @TableField("birth_date_")
    private LocalDate birthDate;

    @ApiModelProperty(value = "入伍时间")
    @TableField("rw_date_")
    private LocalDate rwDate;

    @ApiModelProperty(value = "现军衔时间")
    @TableField("xjx_date_")
    private String xjxDate;

    @ApiModelProperty(value = "职务描述")
    @TableField("job_description")
    private String jobDescription;

    @ApiModelProperty(value = "入党时间")
    @TableField("rd_date")
    private LocalDate rdDate;

    @ApiModelProperty(value = "民族")
    @TableField("nation_")
    private String nation;

    @ApiModelProperty(value = "籍贯")
    @TableField("native_place_")
    private String nativePlace;

    @ApiModelProperty(value = "政治面貌")
    @TableField("political_outlook_")
    private String politicalOutlook;

    @ApiModelProperty(value = "血型")
    @TableField("blood_type_")
    private String bloodType;

    @ApiModelProperty(value = "入伍地地址")
    @TableField("rw_address_")
    private String rwAddress;

    @ApiModelProperty(value = "户籍所在地")
    @TableField("registered_residence_")
    private String registeredResidence;

    @ApiModelProperty(value = "学历学位(字典)")
    @TableField("high_education_")
    private String highEducation;

    @ApiModelProperty(value = "人员类别")
    @TableField("user_class_")
    private String userClass;

    @ApiModelProperty(value = "个人照片地址（URL地址）")
    @TableField("user_photo_url_")
    private String userPhotoUrl;

    @ApiModelProperty(value = "个人档案明细")
    @TableField(exist = false)
    PersonalProfileDto personalProfileDto;

    @ApiModelProperty(value = "xxx工作简历表")
    @TableField(exist = false)
    private List<BizUserWorkDetail> bizUserWorkDetailList;

}
