/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.dao.BizTrainingDataDao;
import com.artfess.data.manager.BizExamIndexDataManager;
import com.artfess.data.manager.BizTrainingDataManager;
import com.artfess.data.model.BizExamIndexData;
import com.artfess.data.model.BizTrainingData;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizTrainingDataManagerImpl
extends BaseManagerImpl<BizTrainingDataDao, BizTrainingData>
implements BizTrainingDataManager {
    @Autowired
    private BizExamIndexDataManager indexDataManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizTrainingData t) {
        BizExamIndexData bizExamIndexData = (BizExamIndexData)this.indexDataManager.get((Serializable)((Object)t.getIndexId()));
        Assert.notNull((Object)((Object)bizExamIndexData), (String)"\u8bad\u7ec3\u6d88\u8017\u6307\u6807\u4e0d\u5b58\u5728");
        if ("1".equals(t.getOperateType())) {
            bizExamIndexData.setNumber(t.getNumber().add(bizExamIndexData.getNumber()));
        } else if ("2".equals(t.getOperateType())) {
            int i = t.getNumber().compareTo(bizExamIndexData.getNumber());
            if (i < 0) {
                throw new BaseException("\u8bad\u7ec3\u6d88\u8017\u6307\u6807\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u67e5\u770b\u5e93\u5b58\u8fdb\u884c\u51fa\u5e93!");
            }
            bizExamIndexData.setNumber(bizExamIndexData.getNumber().subtract(t.getNumber()));
        }
        boolean update = this.indexDataManager.updateById((Object)bizExamIndexData);
        if (update) {
            return this.save((Object)t);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizTrainingData t) {
        BizExamIndexData bizExamIndexData = (BizExamIndexData)this.indexDataManager.get((Serializable)((Object)t.getIndexId()));
        Assert.notNull((Object)((Object)bizExamIndexData), (String)"\u8bad\u7ec3\u6d88\u8017\u6307\u6807\u4e0d\u5b58\u5728");
        if ("1".equals(t.getOperateType())) {
            bizExamIndexData.setNumber(t.getNumber().add(bizExamIndexData.getNumber()));
        } else if ("2".equals(t.getOperateType())) {
            int i = bizExamIndexData.getNumber().compareTo(t.getNumber());
            if (i < 0) {
                throw new BaseException("\u8bad\u7ec3\u6d88\u8017\u6307\u6807\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u67e5\u770b\u5e93\u5b58\u8fdb\u884c\u51fa\u5e93!");
            }
            bizExamIndexData.setNumber(bizExamIndexData.getNumber().subtract(t.getNumber()));
        }
        boolean update = this.indexDataManager.updateById((Object)bizExamIndexData);
        if (update) {
            return this.updateById((Object)t);
        }
        return false;
    }

    @Override
    public void saveList(List<BizTrainingData> list) {
        List indexDataList = this.indexDataManager.list();
        Map<String, BizExamIndexData> indexDataMap = indexDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText((String)data.getIndexName(), (String)"\u8bf7\u586b\u5199\u5355\u4f4d");
            if (!CollectionUtils.isEmpty((Map)indexDataMap) && null != indexDataMap.get(data.getIndexName())) {
                data.setIndexId(((BizExamIndexData)((Object)((Object)indexDataMap.get(data.getIndexName())))).getId());
            }
        });
        this.saveBatch(list);
    }

    @Override
    public PageList<BizTrainingData> findByPage(QueryFilter<BizTrainingData> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizTrainingData> result = ((BizTrainingDataDao)this.baseMapper).findByPage((IPage<BizTrainingData>)this.convert2IPage(pageBean), (Wrapper<BizTrainingData>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

