/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u88c5\u5907\u7cfb\u7edf"})
@RequestMapping(value={"/exam/equipment/sys/"})
@ApiGroup(group={"group_biz"})
public class ExamEquipmentSysController
extends BaseController<ExamEquipmentSysManager, ExamEquipmentSys> {
    private static final Logger log = LoggerFactory.getLogger(ExamEquipmentSysController.class);

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u7c7b\u522b\u4e13\u4e1a\u88c5\u5907\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u4eba\u5458\u7c7b\u522b\u4e13\u4e1a\u88c5\u5907\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u4eba\u5458\u7c7b\u522b\u4e13\u4e1a\u88c5\u5907\u4e0b\u62c9\u6811") @RequestBody ExamEquipmentSys entity) {
        log.info("\u83b7\u53d6\u88c5\u5907\u7cfb\u7edf\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<ExamSubjectType> list = ((ExamEquipmentSysManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamEquipmentSys t) {
        boolean result = ((ExamEquipmentSysManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamEquipmentSys t) {
        boolean result = ((ExamEquipmentSysManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/findById/{id}"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u88c5\u5907\u4fe1\u606f")
    public ExamEquipmentSys findById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamEquipmentSysManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/findByBindPos/{ids}"})
    @ApiOperation(value="\u6839\u636e\u4e13\u4e1a\u88c5\u5907id\u83b7\u53d6\u5df2\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u5c97\u4f4d,\u53ef\u4ee5\u662f\u591a\u4e2a\u4e13\u4e1a\u88c5\u5907id")
    public List<PositionVo> findByBindPos(@ApiParam(name="ids", value="\u5b9e\u4f53id") @PathVariable String ids) {
        return ((ExamEquipmentSysManager)this.baseService).findByBindPos(ids);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(ExamEquipmentSys.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((ExamEquipmentSysManager)this.baseService).importExcel(list);
            if (!result) {
                throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25");
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamEquipmentSys> queryFilter) throws Exception {
        PageList page = ((ExamEquipmentSysManager)this.baseService).query(queryFilter);
        ExcelUtils util = new ExcelUtils(ExamEquipmentSys.class);
        util.exportExcel(response, request, page.getRows(), "\u5bfc\u51fa\u4e13\u4e1a\u88c5\u5907");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/sys.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u4e13\u4e1a\u88c5\u5907\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        List<ExamSubjectInfo> list = ((ExamEquipmentSysManager)this.baseService).getSubjectList(idList);
        if (!CollectionUtils.isEmpty(list)) {
            throw new BaseException("\u8be5\u88c5\u5907\u4e0b\u8fd8\u6709\u8bfe\u76ee\uff0c\u8bf7\u5148\u5220\u9664\u8bfe\u76ee\u4fe1\u606f");
        }
        boolean result = ((ExamEquipmentSysManager)this.baseService).removeByIds(idList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ExamEquipmentSys> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamEquipmentSys> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        if (pageBean == null) {
            pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(true));
            queryFilter.setPageBean(pageBean);
        }
        return ((ExamEquipmentSysManager)this.baseService).query(queryFilter);
    }
}

