/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizExamGeneralPlanManager;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.model.BizExamGeneralPlan;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.vo.MonthPlanVo;
import com.artfess.data.vo.QuarterPlanVo;
import com.artfess.data.vo.WeekPlanVo;
import com.artfess.data.vo.YearPlanVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u8bad\u7ec3\u603b\u8ba1\u5212"})
@RequestMapping(value={"/biz/exam/generalPlan/"})
@ApiGroup(group={"group_biz"})
public class BizExamGeneralPlanController
extends BaseController<BizExamGeneralPlanManager, BizExamGeneralPlan> {
    private static final Logger log = LoggerFactory.getLogger(BizExamGeneralPlanController.class);
    @Resource
    private BizExamPlanManager examPlanManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizExamGeneralPlan t) {
        boolean result = ((BizExamGeneralPlanManager)this.baseService).saveInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizExamGeneralPlan getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizExamGeneralPlanManager)this.baseService).findById(id);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizExamGeneralPlan t) {
        boolean result = ((BizExamGeneralPlanManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel/{planType}"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @PathVariable String planType) {
        try {
            List planList = null;
            if ("1".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(YearPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("2".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(QuarterPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("3".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(MonthPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("4".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(WeekPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("5".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(YearPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("6".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(YearPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            } else if ("7".equals(planType)) {
                ExcelUtils excelUtil = new ExcelUtils(YearPlanVo.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList((List)list, BizExamGeneralPlan.class);
            }
            ((BizExamGeneralPlanManager)this.baseService).saveList(planList, planType);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export/{planType}"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizExamPlan> queryFilter, @PathVariable String planType) throws Exception {
        PageList<BizExamPlan> page = this.examPlanManager.findByPage(queryFilter);
        page.getRows().forEach(data -> {
            String type;
            if (null != DictionaryUtils.findByDictValue((String)"xljb", (String)data.getTrainLevel())) {
                type = DictionaryUtils.findByDictValue((String)"xljb", (String)data.getTrainLevel()).getName();
                data.setTrainLevel(type);
            }
            if (null != DictionaryUtils.findByDictValue((String)"xllb", (String)data.getTrainType())) {
                String trainType = DictionaryUtils.findByDictValue((String)"xllb", (String)data.getTrainType()).getName();
                data.setTrainType(trainType);
            }
            if (null != DictionaryUtils.findByDictValue((String)"jdmc", (String)data.getQuarter())) {
                type = DictionaryUtils.findByDictValue((String)"jdmc", (String)data.getQuarter()).getName();
                data.setQuarter(type);
            }
            if (null != DictionaryUtils.findByDictValue((String)"xlfs", (String)data.getWay())) {
                String way = DictionaryUtils.findByDictValue((String)"xlfs", (String)data.getWay()).getName();
                data.setWay(way);
            }
        });
        if ("1".equals(planType)) {
            ExcelUtils util = new ExcelUtils(YearPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "\u5e74\u5ea6\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("2".equals(planType)) {
            ExcelUtils util = new ExcelUtils(QuarterPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), QuarterPlanVo.class);
            util.exportExcel(response, request, list, "\u9636\u6bb5\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("3".equals(planType)) {
            ExcelUtils util = new ExcelUtils(MonthPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), MonthPlanVo.class);
            util.exportExcel(response, request, list, "\u6708\u5ea6\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("4".equals(planType)) {
            ExcelUtils util = new ExcelUtils(WeekPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), WeekPlanVo.class);
            util.exportExcel(response, request, list, "\u5468\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("5".equals(planType)) {
            ExcelUtils util = new ExcelUtils(YearPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "\u6392\u73ed\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("6".equals(planType)) {
            ExcelUtils util = new ExcelUtils(YearPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "\u96c6\u7ea6\u4e13\u4fee\u8bad\u7ec3\u8ba1\u5212\u6570\u636e");
        } else if ("7".equals(planType)) {
            ExcelUtils util = new ExcelUtils(YearPlanVo.class);
            List list = DmpBeanUtil.copyList((List)page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "\u8865\u8bad\u8ba1\u5212\u6570\u636e");
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel/{planType}"})
    public void downTemplate(HttpServletResponse response, @PathVariable String planType) {
        try {
            if ("1".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u5e74\u5ea6\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u5e74\u5ea6\u8bad\u7ec3\u8ba1\u5212\u6570\u636e\u6a21\u677f.xlsx");
            } else if ("2".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u9636\u6bb5\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u9636\u6bb5\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
            } else if ("3".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u6708\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u6708\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
            } else if ("4".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u5468\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u5468\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
            } else if ("5".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u6392\u73ed\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u6392\u73ed\u8bad\u7ec3\u8ba1\u5212\u6570\u636e\u6a21\u677f.xlsx");
            } else if ("6".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u96c6\u7ea6\u4e13\u4fee\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u96c6\u7ea6\u4e13\u4fee\u8bad\u7ec3\u8ba1\u5212\u6570\u636e.xlsx");
            } else if ("7".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u7ba1\u7406\u6570\u636e/\u8865\u8bad\u8ba1\u5212\u6570\u636e.xlsx");
                FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u8865\u8bad\u8ba1\u5212\u6570\u636e.xlsx");
            }
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @ApiOperation(value="\u8bad\u7ec3\u8ba1\u5212\u4e0b\u53d1")
    @GetMapping(value={"/updateStatus"})
    public CommonResult<String> updateStatus(String id) {
        try {
            ((BizExamGeneralPlanManager)this.baseService).updateStatus(id);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u5931\u8d25," + e.getMessage());
        }
    }
}

