package com.artfess.report.bigScreen.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可视化表
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
@ApiModel(value="BladeVisual对象", description="可视化表")
public class BladeVisual extends AutoFillModel<BladeVisual> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "大屏标题")
    @TableField("title_")
    private String title;

    @ApiModelProperty(value = "大屏背景")
    @TableField("background_url_")
    private String backgroundUrl;

    @ApiModelProperty(value = "大屏类型")
    @TableField("category_")
    private String category;

    @ApiModelProperty(value = "发布密码")
    @TableField("password_")
    private String password;

    @ApiModelProperty(value = "状态 0:未发布 1:已发布")
    @TableField("status_")
    private Integer status;

    @ApiModelProperty(value = "是否已删除 0:未删除 1:已删除")
    @TableField("is_dele_")
    private String isDele;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getBackgroundUrl() {
        return backgroundUrl;
    }

    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BladeVisual{" +
            "id=" + id +
            ", title=" + title +
            ", backgroundUrl=" + backgroundUrl +
            ", category=" + category +
            ", password=" + password +
            ", status=" + status +
            ", isDele=" + isDele +
        "}";
    }
}
