package com.artfess.mail.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.mail.model.MailAttachment;
import com.artfess.mail.persistence.dao.MailAttachmentDao;
import com.artfess.mail.persistence.manager.MailAttachmentManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * 外部邮件附件表 处理实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月6日
 */
@Service("mailAttachmentManager")
public class MailAttachmentManagerImpl extends BaseManagerImpl<MailAttachmentDao, MailAttachment> implements MailAttachmentManager{
	@Resource
	FileManager fileManager;

	@Override
	public List<MailAttachment> getByMailId(String mailId) {
		return baseMapper.getByMailId(mailId);
	}

	@Override
	public void updateFilePath(String fileName, String mailId, String filePath) {
		baseMapper.updateFilePath(fileName, mailId, filePath);
	}

	@Override
	public List<MailAttachment> getByOutMailFileIds(String fileIds) throws Exception {
		List<MailAttachment> result = new ArrayList<MailAttachment>();
		if(StringUtil.isEmpty(fileIds)) return result;
		JsonNode jsonNode = JsonUtil.toJsonNode(fileIds);
		for(Object obj:jsonNode){
			ObjectNode json = (ObjectNode)obj;
			String id = json.get("id").textValue();
			DefaultFile file= fileManager.get(id);
			String filePath = AppFileUtil.getBasePath()+File.separator+file.getFilePath();
			MailAttachment attachment = new MailAttachment();
			attachment.setId(id);
			attachment.setFileName(json.get("name").textValue());
			attachment.setFilePath(filePath);
			result.add(attachment);
		}
		return result;
	}

	@Override
	public void delByMailId(String mailId) {
		baseMapper.delByMailId(mailId);
	}
}
