package com.artfess.bpm.plugin.execution.script.plugin;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.artfess.bpm.plugin.execution.script.def.ScriptNodePluginDef;
import com.fasterxml.jackson.databind.node.ObjectNode;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 脚本节点插件运行时
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年11月6日
 */
public class ScriptNodePlugin extends AbstractBpmExecutionPlugin{
	
	@Resource
	GroovyScriptEngine groovyScriptEngine  ;

	public Void execute(BpmExecutionPluginSession pluginSession,
			BpmExecutionPluginDef pluginDef) {
		ScriptNodePluginDef nodeDef=(ScriptNodePluginDef)pluginDef;
		BpmDelegateExecution execution= pluginSession.getBpmDelegateExecution();
		
		Map<String, Object> vars=new HashMap<String, Object>();
		vars.put(BpmConstants.BPMN_EXECUTION_ID, execution.getId());
		vars.put(BpmConstants.BPMN_INST_ID, execution.getBpmnInstId());
		vars.putAll( execution.getVariables());
		vars.put("execution",execution);
		//从上下文获取bo实体数据。
		Map<String,ObjectNode> boDatas= BpmContextUtil.getBoFromContext();
		if(BeanUtils.isNotEmpty(boDatas)){
			vars.putAll(boDatas);
		}
		
		String script=nodeDef.getScript();
		groovyScriptEngine.execute(script, vars);
		return null;
	}

}
