package com.artfess.bpm.plugin.task.tasknotify.def.model;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.string.StringCollections;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NotifyItem implements Serializable{
	private static final long serialVersionUID = 1L;

	/**
	 * 用户分配规则（用于查询用户）
	 */
	private List<UserAssignRule> userAssignRules;

	/**
	 * 消息类型（mail=邮件；inner=内部消息；sms=短信）
	 */
	private List<String> msgTypes = new ArrayList<String>();

	public List<UserAssignRule> getUserAssignRules() {
		return userAssignRules;
	}
	public void setUserAssignRules(List<UserAssignRule> userAssignRules) {
		this.userAssignRules = userAssignRules;
	}
	public List<String> getMsgTypes() {
		return msgTypes;
	}

	public String getMessageTypes(){
		if(BeanUtils.isEmpty(msgTypes)) return "";
		String str="";
		for(String msg:msgTypes){
			str+=msg +",";
		}
		return str.substring(0,str.length()-1);
	}

	public void setMsgTypes(String msgTypes){
		this.msgTypes = StringCollections.toList(msgTypes, ",");
	}
}
