package com.artfess.bo.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoEnt;

import java.io.IOException;
import java.util.List;

/**
 * 业务实体定义属性 处理接口
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月12日
 */
public interface BoAttributeManager extends BaseManager<BoAttribute> {

    /**
     * 根据实体ID获取BO属性
     *
     * @param entId 实体ID
     * @return 返回bo属性列表
     */
    List<BoAttribute> getByEntId(String entId);

    /**
     * 根据BoEnt获取属性列表
     *
     * @param boEnt
     * @return
     */
    List<BoAttribute> getByBoEnt(BoEnt boEnt);

    /**
     * 根据实体ID删除属性。
     *
     * @param entId 实体ID
     */
    void removeByEntId(String entId);

    /**
     * 修改字段状态
     *
     * @param json
     */
    void updateAttrStatus(String json, String alias) throws IOException;

    void recovery(String json, String alias) throws Exception;

    void deleteByDefId(String defId);

}
