package com.artfess.examine.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.examine.manager.ExamRoomInfoManager;
import com.artfess.examine.model.ExamRoomInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考试场地信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Slf4j
@RestController
@Api(tags = "基础数据-考试场地")
@RequestMapping("/exam/room/info/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamRoomInfoController extends BaseController<ExamRoomInfoManager, ExamRoomInfo> {


    @PostMapping("/modifyStatus")
    @ApiOperation("修改场地状态")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.UPDATE, description = "修改场地状态")
    public CommonResult<String> modifyEnabled(@ApiParam(name = "model", value = "设备") @RequestBody ExamRoomInfo entity) {
        log.info("修改场地状态请求参数:{}", JSON.toJSONString(entity));
        boolean b = baseService.modifyStatus(entity);
        log.info("修改场地状态响应结果:{}", b);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


}
