package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserCheck;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.data.manager.BizUserTrainPlanManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 考生训练计划 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Slf4j
@RestController
@Api(tags = "训练数据-考生训练计划")
@RequestMapping("/biz/userTrain/plan/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizUserTrainPlanController extends BaseController<BizUserTrainPlanManager, BizUserTrainPlan> {

    @Autowired
    private BizExamPlanManager examPlanManager;

    @Autowired
    private BaseContext baseContext;

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体(修改训练状态)")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) BizUserTrainPlan t) {
        BizUserTrainPlan plan = this.getById(t.getId());
        Assert.notNull(plan, "训练计划不存在");

        BizExamPlan bizExamPlan = examPlanManager.getById(t.getPlanId());
        Assert.notNull(bizExamPlan, "训练计划不存在");
        if(null == bizExamPlan.getHour()) {
            bizExamPlan.setHour(BigDecimal.ZERO);
        }
        if(t.getHour().doubleValue() >= bizExamPlan.getHour().doubleValue()) {
            t.setStatus("2");
        }else{
            t.setStatus("1");
        }
        boolean result = baseService.updateById(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        if(null != bizExamPlan && "0".equals(plan.getStatus())) {
            if(null == bizExamPlan.getRealityNum()) {
                bizExamPlan.setRealityNum(0L);
            }
            bizExamPlan.setRealityNum(bizExamPlan.getRealityNum() + 1);
            if(bizExamPlan.getRealityNum().doubleValue() == bizExamPlan.getTotalNum()) {
                bizExamPlan.setPlanStatus("2");
            }
            examPlanManager.updateById(bizExamPlan);
        }

        return new CommonResult<>();
    }


    @ApiOperation(value = "导入")
    @PostMapping("/importExcel")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file, String planId) {
        try {
            ExcelUtils<BizUserTrainPlan> excelUtil = new ExcelUtils<>(BizUserTrainPlan.class);
            List<BizUserTrainPlan> list = excelUtil.importExcel(null, file.getInputStream());
            baseService.importList(list, planId);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("导入失败," + e.getMessage());
        }
    }

    @ApiOperation(value = "导出")
    @PostMapping("/export")
    public void export(HttpServletResponse response, HttpServletRequest request,
                       @ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizUserTrainPlan> queryFilter) throws Exception {
        PageList<BizUserTrainPlan> page = this.query(queryFilter);
        ExcelUtils<BizUserTrainPlan> util = new ExcelUtils<BizUserTrainPlan>(BizUserTrainPlan.class);
        util.exportExcel(response, request, page.getRows(), "考生训练计划数据");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/考生训练计划数据.xlsx");
            FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "考生训练计划数据模板.xlsx");
        } catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("你所下载的资源不存在");
        }
    }

    @PostMapping(value="/myTrainPlan", produces={"application/json; charset=utf-8" })
    @ApiOperation("我的训练计划")
    public PageList<BizExamPlan> myTrainPlan(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizExamPlan> queryFilter) {
        queryFilter.addFilter("user_id_", baseContext.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.addFilter("is_dele_", DelStatusEnum.N.getType(), QueryOP.EQUAL);
        return examPlanManager.myTrainPlan(queryFilter);
    }


}
