package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 后装保障需求数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizDemandData对象", description="后装保障需求数据")
public class BizDemandData extends AutoFillModel<BizDemandData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择所属单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "归属单位", column = "A")
    @ApiModelProperty(value = "所属单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "训练课目", column = "B")
    @ApiModelProperty(value = "训练课目")
    @TableField("train_subject_")
    private String trainSubject;

    @NotNull(message = "请选择训练课目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "训练课目id")
    @TableField("train_subject_id_")
    private String trainSubjectId;

    @ApiModelProperty(value = "训练场地id")
    @TableField("space_id_")
    private String spaceId;

    @Excel(name = "训练场地", column = "C")
    @ApiModelProperty(value = "训练场地")
    @TableField("space_name_")
    private String spaceName;

    @Excel(name = "营房", column = "D")
    @ApiModelProperty(value = "营房")
    @TableField("barracks_")
    private String barracks;

    @Excel(name = "油料", column = "E")
    @ApiModelProperty(value = "油料")
    @TableField("oilseed_")
    private String oilseed;

    @Excel(name = "物资", column = "F")
    @ApiModelProperty(value = "物资")
    @TableField("materials_")
    private String materials;

    @Excel(name = "装备", column = "G")
    @ApiModelProperty(value = "装备")
    @TableField("equipment_")
    private String equipment;

    @Excel(name = "弹药", column = "H")
    @ApiModelProperty(value = "弹药")
    @TableField("ammunition_")
    private String ammunition;

    @Excel(name = "摩托小时", column = "I")
    @ApiModelProperty(value = "摩托小时")
    @TableField("motorcycle_hours")
    private String motorcycleHours;

    @Excel(name = "备注", column = "J")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
