package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 能力评估数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@FieldRepeat(fields = {"planId"},message = "该计划已进行过能力评估",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="BizAbilityEvaluationData对象", description="能力评估数据")
public class BizAbilityEvaluationData extends AutoFillModel<BizAbilityEvaluationData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "计划id")
    @TableField("plan_id_")
    private String planId;

    @Excel(name = "年度", column = "A")
    @ApiModelProperty(value = "年度")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "单位", column = "B")
    @ApiModelProperty(value = "单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "训练课目", column = "C")
    @ApiModelProperty(value = "训练课目")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "训练课目id")
    @TableField("subject_id_")
    private String subjectId;

    @Excel(name = "侦察", column = "D")
    @ApiModelProperty(value = "侦察")
    @TableField("reconnoitre_")
    private String reconnoitre;

    @Excel(name = "指控", column = "E")
    @ApiModelProperty(value = "指控")
    @TableField("accuse_")
    private String accuse;

    @Excel(name = "机动", column = "F")
    @ApiModelProperty(value = "机动")
    @TableField("motorized_")
    private String motorized;

    @Excel(name = "打击", column = "G")
    @ApiModelProperty(value = "打击")
    @TableField("crack_down_")
    private String crackDown;

    @Excel(name = "保障", column = "H")
    @ApiModelProperty(value = "保障")
    @TableField("safeguard_")
    private String safeguard;

    @Excel(name = "备注", column = "I")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
