package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizDemandDataDao;
import com.artfess.data.manager.BizDemandDataManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.model.BizDemandData;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 后装保障需求数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizDemandDataManagerImpl extends BaseManagerImpl<BizDemandDataDao, BizDemandData> implements BizDemandDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Autowired
    private BizExamSpaceDataManager spaceDataManager;

    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    public void saveList(List<BizDemandData> list) {

        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));

        List<BizExamSpaceData> spaceDataList = spaceDataManager.list();
        Map<String, BizExamSpaceData> spaceDataMap = spaceDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));

        List<ExamSubjectInfo> subjectInfos = subjectInfoManager.list();
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText(data.getTrainSubject(), "请填写训练名称");
            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(orgMap.get(data.getOrgName()).getId());
            }
            if (!CollectionUtils.isEmpty(spaceDataMap) && null != spaceDataMap.get(data.getSpaceName())) {
                data.setSpaceId(spaceDataMap.get(data.getSpaceName()).getId());
            }

            if (!CollectionUtils.isEmpty(subjectInfoMap) && null != subjectInfoMap.get(data.getTrainSubject())) {
                data.setTrainSubjectId(subjectInfoMap.get(data.getTrainSubject()).getId());
            }
        });

        this.saveBatch(list);
    }
}
