package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.data.manager.BizDataExportManager;
import com.artfess.data.model.BizDemandData;
import com.artfess.data.vo.SysLogsVo;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.data.model.BizDataImport;
import com.artfess.data.manager.BizDataImportManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 基站数据导入 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-11-14
 */
@Slf4j
@RestController
@Api(tags = "训练数据-基站数据导入")
@RequestMapping("/biz/data/import/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizDataImportController extends BaseController<BizDataImportManager, BizDataImport> {

    @Autowired
    private BizDataExportManager exportManager;


    @ApiOperation(value = "导入")
    @PostMapping(value = "/importExcel", produces={"application/json; charset=utf-8" })
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file) {
        try {
            ExcelUtils<SysLogsVo> excelUtil = new ExcelUtils<>(SysLogsVo.class);
            List<SysLogsVo> list = excelUtil.importExcel(null, file.getInputStream());
            baseService.saveList(list, null);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("导入失败," + e.getMessage());
        }
    }
}
