package com.artfess.examine.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 科目题目类型统计
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-04
 */
@Data
@ApiModel(value="SubjectQuestionTypeVo对象", description="科目题目类型统计")
public class SubjectQuestionTypeVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "课目id")
    private String id;

    @ApiModelProperty(value = "试题题型【字典】（1：单选，2：多选，3：判断，4：填空，5：简答，6：操作）")
    private String type;

    @ApiModelProperty(value = "题型数量")
    private Integer count;

    @ApiModelProperty(value = "分数")
    private BigDecimal score;

    @ApiModelProperty(value = "课目名称")
    private String subjectName;

    @ApiModelProperty(value = "简单")
    private Integer simple = 0;

    @ApiModelProperty(value = "普通")
    private Integer ordinary = 0;

    @ApiModelProperty(value = "困难")
    private Integer difficult = 0;

}
