package com.artfess.examine.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 我的试卷信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-04
 */
@Data
@ApiModel(value="MyExamInfoVo对象", description="我的试卷信息")
public class MyExamInfoVo  {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "试卷名称")
    private String paperName;

    @ApiModelProperty(value = "考生id")
    private String userId;

    @ApiModelProperty(value = "考生名称")
    private String userName;

    @ApiModelProperty(value = "考试剩余时长(毫秒)")
    private BigDecimal timeLength;

    @ApiModelProperty(value = "页面切换次数(达到配置数量自动交卷)")
    private Integer switchCount;

    @ApiModelProperty(value = "已切换次数")
    private Integer inSwitchCount;

    @ApiModelProperty(value = "开考时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "交卷时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "记录ID")
    private String recordId;

    @ApiModelProperty(value = "总分数")
    private BigDecimal totalScore;

    @ApiModelProperty(value = "总得分")
    private BigDecimal userScore;

    @ApiModelProperty(value = "总题目数")
    private Integer totalNumber;

    @ApiModelProperty(value = "问题列表")
    private List<QuestionsInfoVo> questionsInfoVos;
}
