package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 年度考生综合评定表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-28
 */
@Data
@ApiModel(value="ExamUserEvaluation对象", description="年度考生综合评定表")
public class ExamUserEvaluation extends AutoFillModel<ExamUserEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "最后评定时间")
    @TableField("evaluation_time_")
    private LocalDateTime evaluationTime;

    @ApiModelProperty(value = "已考科目数")
    @TableField("in_count_")
    private Integer inCount;

    @ApiModelProperty(value = "未考科目数")
    @TableField("not_count_")
    private Integer notCount;

    @ApiModelProperty(value = "总科目数")
    @TableField("total_count")
    private Integer totalCount;

    @ApiModelProperty(value = "科目名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目id")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "评价等级 1：优秀 2：良好 3：及格 4：不及格")
    @TableField("level_")
    private Integer level;

    @ApiModelProperty(value = "岗位id")
    @TableField("position_id_")
    private String positionId;


    @ApiModelProperty(value = "岗位名称")
    @TableField(exist = false)
    private String positionName;

    @ApiModelProperty(value = "职业教育分数")
    @TableField("vocational_education_score_")
    private Integer vocationalEducationScore;

    @ApiModelProperty(value = "职业教育评定（字典评定等级）")
    @TableField("vocational_education_evaluation_")
    private String vocationalEducationEvaluation;

    @ApiModelProperty(value = "个人上一级xx综合鉴定描述")
    @TableField("comprehensive_appraisal_description_")
    private String comprehensiveAppraisalDescription;

    @ApiModelProperty(value = "个人年度xx总体评价描述")
    @TableField("overall_evaluation_description_")
    private String overallEvaluationDescription;

    @ApiModelProperty(value = "个人年度xx总体评价时间")
    @TableField("overall_evaluation_time_")
    private LocalDate overallEvaluationTime;

}
