package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 课目专业装备中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-18
 */
@ApiModel(value="ExamSubjectSys对象", description="课目专业装备中间表")
public class ExamSubjectSys extends BaseModel<ExamSubjectSys> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "装备系统id")
    @TableField("major_id_")
    private String majorId;

    @ApiModelProperty(value = "课目id")
    @TableField("subject_id_")
    private String subjectId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMajorId() {
        return majorId;
    }

    public void setMajorId(String majorId) {
        this.majorId = majorId;
    }

    public String getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamSubjectSys{" +
            "id=" + id +
            ", majorId=" + majorId +
            ", subjectId=" + subjectId +
        "}";
    }
}
