package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 月训练计划文件表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2025-03-03
 */
@Data
@ApiModel(value="BizMonthPlanFile对象", description="月训练计划文件表")
public class BizMonthPlanFile extends AutoFillModel<BizMonthPlanFile> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "月计划ID")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "文件")
    @TableField("file_")
    private String file;

    @ApiModelProperty(value = "上传人ID，后端获取")
    @TableField("uploading_user_id_")
    private String uploadingUserId;

    @ApiModelProperty(value = "上传人姓名，后端获取")
    @TableField("uploading_user_name_")
    private String uploadingUserName;

    @ApiModelProperty(value = "上传时间")
    @TableField("uploading_date_")
    private LocalDate uploadingDate;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
