package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WordUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.file.util.AppFileUtil;
import com.artfess.poi.util.FileDownloadUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 年度考核成绩表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-12-07
 */
@Service
public class ExamUserEvaluationDetailManagerImpl extends BaseManagerImpl<ExamUserEvaluationDetailDao, ExamUserEvaluationDetail> implements ExamUserEvaluationDetailManager {

    @Override
    public PageList<ExamUserEvaluationDetail> findByPage(QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamUserEvaluationDetail> result = baseMapper.findByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void personArchivesExport(QueryFilter<ExamUserEvaluationDetail> queryFilter, HttpServletResponse response) {
        PageList<ExamUserEvaluationDetail> result = this.findByPage(queryFilter);
        String fileId = UniqueIdUtil.getSuid();
        String path = AppFileUtil.createFileMkdirs("ftl" + File.separator + fileId);

        Map<String, List<ExamUserEvaluationDetail>> map = result.getRows().stream().
                filter(item -> !StringUtil.isEmpty(item.getUserId())).collect(Collectors.groupingBy(ExamUserEvaluationDetail::getUserId));
        map.forEach((userId, list) -> {
            if(CollectionUtils.isEmpty(list)) {
                return;
            }
            JSONObject dataMap = new JSONObject();
            dataMap.put("year", list.get(0).getYear());
            dataMap.put("userName", list.get(0).getUserName());
            String examTime = DateFormatUtil.formaDateTime(list.get(0).getCreateTime());
            dataMap.put("examTime", examTime);
            dataMap.put("mobile", list.get(0).getMobile());
            dataMap.put("sex", list.get(0).getSex());
            dataMap.put("idCard", list.get(0).getIdCard());
            dataMap.put("birthday", list.get(0).getBirthday());
            dataMap.put("entryDate", list.get(0).getEntryDate());
            dataMap.put("education", list.get(0).getEducation());
            list.forEach(detail -> {
                detail.setLevelDesc(ScoreLevelEnum.getDesc(detail.getLevel()));
            });
            dataMap.put("list", list);
            //文件唯一名称
            String fileOnlyName =  list.get(0).getUserName() + "个人档案.doc";
            String ftlPath = AppFileUtil.createFilePath("ftl" + File.separator + fileId, fileOnlyName);
            /** 生成word */
            WordUtil.createWord(response, dataMap, "个人档案.ftl", ftlPath, fileOnlyName);

        });
        //生成压缩包
        ZipUtil.zip(path, true);
        try {
            FileDownloadUtil.fileDownload(response, new File(path + ".zip"), "个人档案台帐.zip");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PageList<UserExamVo> userStudyAnalyse(QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<UserExamVo> result = baseMapper.userStudyAnalyse(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public String getSubjectNames(String positionId, String year, String userId) {
        return this.baseMapper.getSubjectNames(positionId,year,userId);
    }

}
