package com.artfess.examine.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.examine.manager.ExamCameraInfoManager;
import com.artfess.examine.model.ExamCameraInfo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考场设备管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Slf4j
@RestController
@Api(tags = "基础数据-考场设备")
@RequestMapping("/exam/camera/info/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamCameraInfoController extends BaseController<ExamCameraInfoManager, ExamCameraInfo> {

}
