package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;

/**
 * xxx工作简历表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value="BizUserWorkDetail对象", description="xxx工作简历表")
public class BizUserWorkDetail extends AutoFillModel<BizUserWorkDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案id（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "填档年份（格式：2024）")
    @TableField("td_year_")
    private Integer tdYear;

    @ApiModelProperty(value = "起始时间（格式：2024/12/10）")
    @TableField("start_date_")
    private LocalDate startDate;

    @ApiModelProperty(value = "截止时间（格式：2024/12/10）")
    @TableField("end_date_")
    private LocalDate endDate;

    @ApiModelProperty(value = "在何单位任职介绍")
    @TableField("position_")
    private String position;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

}
