package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.SyncAnnotation;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.data.model.BizMonthPlanFile;
import com.artfess.data.manager.BizMonthPlanFileManager;

/**
 * 月训练计划文件表 前端控制器
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2025-03-03
 */
@RestController
@RequestMapping("/bizMonthPlanFile/v1/")
@Api(tags = "训练计划-月训练计划文件表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMonthPlanFileController extends BaseController<BizMonthPlanFileManager, BizMonthPlanFile> {

    @PostMapping("/")
    @ApiOperation(value = "添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) BizMonthPlanFile t) {
        boolean result = baseService.saveInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @SyncAnnotation(httpMethod = "put")
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) BizMonthPlanFile t) {
        boolean result = baseService.updateInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }
}
