/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.data.dao.BizExamPlanDao;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.manager.BizTrainMaterialManager;
import com.artfess.data.manager.BizUserCheckManager;
import com.artfess.data.manager.BizUserTrainPlanManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.data.model.BizTrainMaterial;
import com.artfess.data.model.BizUserCheck;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.examine.manager.ExamNoticeManager;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamNotice;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import com.artfess.examine.vo.PositionVo;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizExamPlanManagerImpl
extends BaseManagerImpl<BizExamPlanDao, BizExamPlan>
implements BizExamPlanManager {
    @Autowired
    private BizUserTrainPlanManager userTrainPlanManager;
    @Autowired
    private BizTrainMaterialManager materialManager;
    @Autowired
    private BizUserCheckManager userCheckManager;
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;
    @Autowired
    private BizExamSpaceDataManager spaceDataManager;
    @Autowired
    private ExamEquipmentSysManager equipmentSysManager;
    @Resource
    private ExamUserEvaluationDetailDao userEvaluationDetailDao;
    @Resource
    IUserService userServiceImpl;
    @Autowired
    private ExamNoticeManager noticeManager;
    @Autowired
    private BaseContext baseContext;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizExamPlan t) {
        if ("1".equals(t.getPlanType())) {
            if (StringUtil.isEmpty((String)t.getYear())) {
                t.setYear(String.valueOf(LocalDate.now().getYear()));
            }
        } else if ("2".equals(t.getPlanType())) {
            Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
        } else if ("3".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
        } else if ("4".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
        } else {
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
        }
        t.setPlanStatus("0");
        t.setRealityNum(0L);
        boolean save = this.save((Object)t);
        if (save) {
            this.processUserTrainPlans(t);
            int size = t.getUserTrainPlans().size();
            t.setTotalNum(Long.valueOf(size));
            this.processMaterials(t);
            return save;
        }
        return false;
    }

    private void processMaterials(BizExamPlan t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizTrainMaterial::getPlanId, (Object)t.getId());
        this.materialManager.remove((Wrapper)lambdaQueryWrapper);
        t.getMaterials().forEach(user -> {
            Assert.hasText((String)user.getIndexId(), (String)"\u8bf7\u9009\u62e9\u8bad\u7ec3\u6307\u6807");
            user.setPlanId(t.getId());
        });
        this.materialManager.saveBatch(t.getMaterials());
    }

    private void processUserTrainPlans(BizExamPlan t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizUserTrainPlan::getPlanId, (Object)t.getId());
        this.userTrainPlanManager.remove((Wrapper)lambdaQueryWrapper);
        t.getUserTrainPlans().forEach(user -> {
            Assert.hasText((String)user.getUserId(), (String)"\u8bf7\u9009\u62e9\u57f9\u8bad\u8003\u751f");
            user.setPlanId(t.getId());
            user.setStatus("0");
        });
        this.userTrainPlanManager.saveBatch(t.getUserTrainPlans());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizExamPlan t) {
        BizExamPlan bizExamPlan = (BizExamPlan)this.get((Serializable)((Object)t.getId()));
        if (!"0".equals(bizExamPlan.getPlanStatus())) {
            throw new BaseException("\u5df2\u4e0b\u53d1\u7684\u8ba1\u5212\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539");
        }
        if ("1".equals(t.getPlanType())) {
            if (StringUtil.isEmpty((String)t.getYear())) {
                t.setYear(String.valueOf(LocalDate.now().getYear()));
            }
        } else if ("2".equals(t.getPlanType())) {
            Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
        } else if ("3".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
        } else if ("4".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
        } else {
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
        }
        int size = t.getUserTrainPlans().size();
        t.setTotalNum(Long.valueOf(size));
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processUserTrainPlans(t);
            this.processMaterials(t);
            return save;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(String id) {
        BizExamPlan bizExamPlan = this.findById(id);
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        if (!"0".equals(bizExamPlan.getPlanStatus())) {
            throw new BaseException("\u5df2\u4e0b\u53d1\u7684\u8ba1\u5212\u4e0d\u80fd\u518d\u6b21\u4e0b\u53d1");
        }
        Assert.notEmpty(bizExamPlan.getUserTrainPlans(), (String)"\u8bf7\u9009\u62e9\u8981\u53c2\u8bad\u7684\u8003\u751f");
        bizExamPlan.setPlanStatus("1");
        boolean update = this.updateById((Object)bizExamPlan);
        if (update) {
            this.executorService.execute(() -> {
                try {
                    if ("4".equals(bizExamPlan.getPlanType())) {
                        this.processUserChecks(bizExamPlan);
                    }
                    this.sendNotice(bizExamPlan);
                }
                catch (Exception e) {
                    this.log.error("\u751f\u6210\u8003\u52e4\u6570\u636e\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
    }

    private void sendNotice(BizExamPlan bizExamPlan) {
        String planTypeName = null;
        if (null != DictionaryUtils.findByDictValue((String)"jhlx", (String)bizExamPlan.getPlanType())) {
            planTypeName = DictionaryUtils.findByDictValue((String)"jhlx", (String)bizExamPlan.getPlanType()).getName();
        }
        String userName = this.baseContext.getCurrentUserName();
        StringBuffer sb = new StringBuffer();
        StringBuffer titleSb = new StringBuffer();
        titleSb.append(bizExamPlan.getYear() + "\u5e74");
        sb.append(userName + "\u5728" + DateFormatUtil.formaDatetTime((LocalDateTime)bizExamPlan.getCreateTime()) + "\u4e0b\u53d1\u4e86" + bizExamPlan.getYear());
        if ("2".equals(bizExamPlan.getPlanType())) {
            sb.append("\u7b2c" + bizExamPlan.getQuarter());
            titleSb.append("\u7b2c" + bizExamPlan.getQuarter() + "\u5b63\u5ea6");
        } else if ("3".equals(bizExamPlan.getPlanType())) {
            sb.append(bizExamPlan.getMonth());
            titleSb.append(bizExamPlan.getMonth() + "\u6708");
        } else if ("4".equals(bizExamPlan.getPlanType())) {
            sb.append(bizExamPlan.getMonth() + "\u6708" + bizExamPlan.getWeek());
            titleSb.append(bizExamPlan.getMonth() + "\u6708" + bizExamPlan.getWeek());
        }
        sb.append(planTypeName + "\u8bad\u7ec3\u8ba1\u5212\uff0c\u8bf7\u6d89\u53ca\u8bad\u7ec3\u7684\u76f8\u5173\u5355\u4f4d\u5728" + bizExamPlan.getStartTime() + "\u81f3" + bizExamPlan.getEndTime() + "\u8bad\u7ec3\u671f\u95f4\u79ef\u6781\u53c2\u4e0e\u8bad\u7ec3\u3002");
        titleSb.append("\u8bad\u7ec3\u8ba1\u5212\u901a\u77e5");
        ExamNotice examNotice = new ExamNotice();
        examNotice.setTitle(titleSb.toString());
        examNotice.setContent(sb.toString());
        examNotice.setStatus("0");
        examNotice.setEndTime(LocalDateTime.of(bizExamPlan.getEndTime().getYear(), bizExamPlan.getEndTime().getMonth(), bizExamPlan.getEndTime().getDayOfMonth(), 23, 59, 59));
        examNotice.setType("2");
        this.noticeManager.save((Object)examNotice);
    }

    private void processUserChecks(BizExamPlan bizExamPlan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"plan_id_", (Object)bizExamPlan.getId());
        List list = this.userTrainPlanManager.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        if (null == bizExamPlan.getStartTime() || null == bizExamPlan.getEndTime()) {
            return;
        }
        List dateList = DateUtils.getDatesBetween((LocalDate)bizExamPlan.getStartTime(), (LocalDate)bizExamPlan.getEndTime());
        ArrayList userCheckList = Lists.newArrayList();
        list.forEach(user -> dateList.forEach(date -> {
            BizUserCheck userCheck = new BizUserCheck();
            userCheck.setSubjectId(bizExamPlan.getSubjectId());
            userCheck.setSubjectName(bizExamPlan.getSubjectName());
            userCheck.setPlanId(bizExamPlan.getId());
            userCheck.setOrgId(user.getOrgId());
            userCheck.setOrgName(user.getOrgName());
            userCheck.setCheckDate(DateFormatUtil.formatDate((LocalDate)date));
            userCheck.setStatus("0");
            userCheck.setMonth(date.getMonthValue());
            userCheck.setWeek(bizExamPlan.getWeek());
            userCheck.setUserId(user.getUserId());
            userCheck.setUserName(user.getUserName());
            userCheckList.add(userCheck);
        }));
        this.userCheckManager.saveBatch(userCheckList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUser(BizExamPlan t) {
        if (CollectionUtils.isEmpty(t.getUserTrainPlans())) {
            throw new BaseException("\u8bf7\u6dfb\u52a0\u8981\u65b0\u589e\u7684\u8003\u751f");
        }
        ArrayList records = Lists.newArrayList();
        t.getUserTrainPlans().forEach(vo -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_id_", (Object)vo.getUserId());
            queryWrapper.eq((Object)"plan_id_", (Object)t.getId());
            List list = this.userTrainPlanManager.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                throw new RuntimeException(vo.getUserName() + "\u5df2\u5728\u57f9\u8bad\u8ba1\u5212\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
        });
        this.userTrainPlanManager.saveBatch(records);
    }

    @Override
    @Scheduled(cron="0 0 23 * * ? ")
    public void updatePlanStatus() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String[] plans = new String[]{"0", "2"};
        lambdaQueryWrapper.notIn(BizExamPlan::getPlanStatus, Arrays.asList(plans));
        lambdaQueryWrapper.ge(BizExamPlan::getEndTime, (Object)LocalDate.now());
        lambdaQueryWrapper.eq(BizExamPlan::getIsDele, (Object)DelStatusEnum.N.getType());
        List list = this.list((Wrapper)lambdaQueryWrapper);
        list.forEach(plan -> plan.setPlanStatus("3"));
        boolean b = this.updateBatchById(list);
    }

    @Override
    public void saveList(List<BizExamPlan> list, String planType) {
        Assert.hasText((String)planType, (String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7c7b\u578b");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List subjectInfos = this.subjectInfoManager.list((Wrapper)queryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        QueryWrapper sysQueryWrapper = new QueryWrapper();
        sysQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List sysList = this.equipmentSysManager.list((Wrapper)sysQueryWrapper);
        Map<String, ExamEquipmentSys> sysMap = sysList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        QueryWrapper spaceDataQueryWrapper = new QueryWrapper();
        spaceDataQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List spaceDataList = this.spaceDataManager.list((Wrapper)spaceDataQueryWrapper);
        Map<String, BizExamSpaceData> spaceDateMap = spaceDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<PositionVo> positionVoList = this.userEvaluationDetailDao.getPositionList();
        Map<String, PositionVo> positionMap = positionVoList.stream().collect(Collectors.toMap(item -> item.getPositionName(), item -> item));
        List userList = this.userServiceImpl.getUserListByGroup("role", "jly");
        Map<String, IUser> userMap = userList.stream().collect(Collectors.toMap(item -> item.getFullname(), item -> item));
        list.forEach(t -> {
            t.setPlanType(planType);
            if (null != DictionaryUtils.getDictInfo((String)"xllb", (String)t.getTrainType())) {
                String trainType = DictionaryUtils.getDictInfo((String)"xllb", (String)t.getTrainType()).getValue();
                t.setTrainType(trainType);
            }
            if (null != DictionaryUtils.getDictInfo((String)"xljb", (String)t.getTrainLevel())) {
                String trainLevel = DictionaryUtils.getDictInfo((String)"xljb", (String)t.getTrainLevel()).getValue();
                t.setTrainLevel(trainLevel);
            }
            if (null != DictionaryUtils.getDictInfo((String)"jdmc", (String)t.getQuarter())) {
                String type = DictionaryUtils.getDictInfo((String)"jdmc", (String)t.getQuarter()).getValue();
                t.setQuarter(type);
            }
            if (null != DictionaryUtils.getDictInfo((String)"xlfs", (String)t.getWay())) {
                String way = DictionaryUtils.getDictInfo((String)"xlfs", (String)t.getWay()).getValue();
                t.setWay(way);
            }
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
            if ("1".equals(planType)) {
                Assert.hasText((String)t.getYear(), (String)"\u8bf7\u586b\u5199\u5e74\u4efd");
            } else if ("2".equals(planType)) {
                Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
            } else if ("3".equals(planType)) {
                Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
            } else if ("4".equals(planType)) {
                Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
            }
            if (!CollectionUtils.isEmpty((Map)sysMap) && null != sysMap.get(t.getMajorName())) {
                t.setMajorId(((ExamEquipmentSys)((Object)((Object)sysMap.get(t.getMajorName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)subjectInfoMap) && null != subjectInfoMap.get(t.getSubjectName())) {
                t.setSubjectId(((ExamSubjectInfo)((Object)((Object)subjectInfoMap.get(t.getSubjectName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(t.getOrgName())) {
                t.setOrgId(((OrgVo)((Object)((Object)orgMap.get(t.getOrgName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)spaceDateMap) && null != spaceDateMap.get(t.getSpaceName())) {
                t.setSpaceId(((BizExamSpaceData)((Object)((Object)spaceDateMap.get(t.getSpaceName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)positionMap) && null != positionMap.get(t.getPost())) {
                t.setPostId(((PositionVo)positionMap.get(t.getPost())).getPositionId());
            }
            if (!CollectionUtils.isEmpty((Map)userMap) && null != positionMap.get(t.getCoachName())) {
                t.setCoachId(((IUser)userMap.get(t.getCoachName())).getUserId());
            }
        });
        this.saveBatch(list);
    }

    @Override
    public List<JSONObject> planStatistical() {
        return ((BizExamPlanDao)this.baseMapper).planStatistical(AuthenticationUtil.getCurrentUserId());
    }

    @Override
    public List<JSONObject> trainPlanStylolitic(TrainReqVo reqVo) {
        return ((BizExamPlanDao)this.baseMapper).trainPlanStylolitic(reqVo);
    }

    @Override
    public List<JSONObject> orgYearTrainPlan(TrainReqVo reqVo) {
        return ((BizExamPlanDao)this.baseMapper).orgYearTrainPlan(reqVo);
    }

    @Override
    public BizExamPlan findById(String id) {
        BizExamPlan bizExamPlan = (BizExamPlan)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizUserTrainPlan::getPlanId, (Object)id);
        List bizUserTrainPlans = this.userTrainPlanManager.list((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper materialLambdaQueryWrapper = new LambdaQueryWrapper();
        materialLambdaQueryWrapper.eq(BizTrainMaterial::getPlanId, (Object)id);
        List trainMaterials = this.materialManager.list((Wrapper)materialLambdaQueryWrapper);
        bizExamPlan.setUserTrainPlans(bizUserTrainPlans);
        bizExamPlan.setMaterials(trainMaterials);
        return bizExamPlan;
    }

    @Override
    public PageList<BizExamPlan> myTrainPlan(QueryFilter<BizExamPlan> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizExamPlan> result = ((BizExamPlanDao)this.baseMapper).myTrainPlan((IPage<BizExamPlan>)this.convert2IPage(pageBean), (Wrapper<BizExamPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizExamPlan> monthPlanStatistical(QueryFilter<BizExamPlan> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizExamPlan> result = ((BizExamPlanDao)this.baseMapper).monthPlanStatistical((IPage<BizExamPlan>)this.convert2IPage(pageBean), (Wrapper<BizExamPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizExamPlan> findByPage(QueryFilter<BizExamPlan> queryFilter) {
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("org_id_", (Object)currentAndChildOrgIds, QueryOP.IN, FieldRelation.OR);
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizExamPlan> result = ((BizExamPlanDao)this.baseMapper).findByPage((IPage<BizExamPlan>)this.convert2IPage(pageBean), (Wrapper<BizExamPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<BizExamPlan> queryInfo(QueryFilter<BizExamPlan> queryFilter) {
        PageList query = this.query(queryFilter);
        if (CollectionUtils.isEmpty((Collection)query.getRows())) {
            return query;
        }
        List planIds = query.getRows().stream().map(BizExamPlan::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BizUserTrainPlan::getPlanId, planIds);
        Map<String, List<BizUserTrainPlan>> userPlanMap = this.userTrainPlanManager.list((Wrapper)queryWrapper).stream().collect(Collectors.groupingBy(BizUserTrainPlan::getPlanId));
        query.getRows().forEach(e -> {
            if (userPlanMap.containsKey(e.getId())) {
                int userNum = ((List)userPlanMap.get(e.getId())).size();
                BigDecimal hour = e.getHour();
                BigDecimal userHour = Optional.ofNullable(userPlanMap.get(e.getId())).orElse(Collections.emptyList()).stream().map(plan -> {
                    BigDecimal planHour = plan.getHour();
                    return planHour != null && planHour.compareTo(hour) > 0 ? hour : planHour;
                }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal remainingDuration = userHour.divide(BigDecimal.valueOf(userNum), 2, RoundingMode.HALF_UP);
                e.setRemainingDuration(remainingDuration);
            }
        });
        return query;
    }
}

