/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizDemandDataDao;
import com.artfess.data.manager.BizDemandDataManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.model.BizDemandData;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizDemandDataManagerImpl
extends BaseManagerImpl<BizDemandDataDao, BizDemandData>
implements BizDemandDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Autowired
    private BizExamSpaceDataManager spaceDataManager;
    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    public void saveList(List<BizDemandData> list) {
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List spaceDataList = this.spaceDataManager.list();
        Map<String, BizExamSpaceData> spaceDataMap = spaceDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List subjectInfos = this.subjectInfoManager.list();
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText((String)data.getTrainSubject(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u540d\u79f0");
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(((OrgVo)((Object)((Object)orgMap.get(data.getOrgName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)spaceDataMap) && null != spaceDataMap.get(data.getSpaceName())) {
                data.setSpaceId(((BizExamSpaceData)((Object)((Object)spaceDataMap.get(data.getSpaceName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)subjectInfoMap) && null != subjectInfoMap.get(data.getTrainSubject())) {
                data.setTrainSubjectId(((ExamSubjectInfo)((Object)((Object)subjectInfoMap.get(data.getTrainSubject())))).getId());
            }
        });
        this.saveBatch(list);
    }
}

