/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.vo.SettingYearVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u5e74\u5ea6\u8bc4\u5b9a"})
@RequestMapping(value={"/exam/user/evaluation/"})
@ApiGroup(group={"group_biz"})
public class ExamUserEvaluationController
extends BaseController<ExamUserEvaluationManager, ExamUserEvaluation> {
    private static final Logger log = LoggerFactory.getLogger(ExamUserEvaluationController.class);
    @Autowired
    private ExamUserRecordManager userRecordManager;
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/detailPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8be6\u60c5\u8bb0\u5f55-\u4ece\u5e74\u5ea6\u8bc4\u5b9a\u5206\u9875\u754c\u9762\u5f39\u51fa\uff0c\u5165\u53c2\u8bc4\u5b9aid e.id_,\u5176\u4ed6\u53c2\u6570\u548c\u6211\u7684\u8bd5\u5377\u4e00\u6837")
    public PageList<ExamUserRecord> detailPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        AtomicReference flag = new AtomicReference();
        queryFilter.getQuerys().forEach(queryField -> {
            if ("e.id_".equals(queryField.getProperty()) && null == queryField.getValue()) {
                queryField.setValue((Object)"-1");
            }
        });
        queryFilter.addFilter("b.paper_type_", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("s.status_", (Object)QuestionStateEnum.finish.getType(), QueryOP.EQUAL);
        return this.userRecordManager.detailPage(queryFilter);
    }

    @GetMapping(value={"/evaluationDetail/{id}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bc4\u5b9a\u8be6\u60c5\u5217\u8868\uff0c\u5e74\u5ea6\u4e0a\u62a5\uff080\uff1a\u672a\u4e0a\u62a5\u30011\uff1a\u5df2\u4e0a\u62a5\uff09")
    public CommonResult evaluationDetail(@ApiParam(name="id", value="\u5e74\u5ea6\u8bc4\u5b9aid") @PathVariable String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ExamUserEvaluationDetail> list = ((ExamUserEvaluationManager)this.baseService).evaluationDetail(id);
        map.put("list", list);
        String reportStatus = ((ExamUserEvaluationManager)this.baseService).getReportStatus();
        map.put("reportStatus", reportStatus);
        return CommonResult.success(map, (String)"");
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ExamUserEvaluation> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return ((ExamUserEvaluationManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/myYearPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u5e74\u5ea6\u8bc4\u5b9a")
    public PageList<ExamUserEvaluation> myYearPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        queryFilter.addFilter("u.id_", (Object)AuthenticationUtil.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.getQuerys().removeIf(s -> "s.paper_id_".equals(s.getProperty()));
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("e.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamUserEvaluationManager)this.baseService).myYearPage(queryFilter);
    }

    @PostMapping(value={"/addSubject"})
    @ApiOperation(value="\u8003\u751f\u6dfb\u52a0\u5e74\u5ea6\u8003\u6838\u8bfe\u76ee")
    public CommonResult<String> addSubject(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody ExamUserEvaluation t) {
        log.info("\u8003\u751f\u6dfb\u52a0\u5e74\u5ea6\u8003\u6838\u8bfe\u76ee\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)t)));
        boolean result = ((ExamUserEvaluationManager)this.baseService).addSubject(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/delSubject"})
    @ApiOperation(value="\u8003\u751f\u5220\u9664\u5e74\u5ea6\u8003\u6838\u8bfe\u76ee")
    public CommonResult<String> delSubject(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody ExamUserEvaluation t) {
        log.info("\u8003\u751f\u5220\u9664\u5e74\u5ea6\u8003\u6838\u8bfe\u76ee\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)t)));
        boolean result = ((ExamUserEvaluationManager)this.baseService).delSubject(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/settingYear"})
    @ApiOperation(value="\u8bbe\u7f6e\u5e74\u5ea6\u6700\u7ec8\u6210\u7ee9")
    public CommonResult<String> settingYear(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SettingYearVo t) {
        log.info("\u8bbe\u7f6e\u5e74\u5ea6\u6700\u7ec8\u6210\u7ee9\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)t));
        boolean result = ((ExamUserEvaluationManager)this.baseService).settingYear(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @ApiOperation(value="\u6210\u7ee9\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="orgId", required=false) String orgId) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(ExamUserEvaluationDetail.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((ExamUserEvaluationManager)this.baseService).importExcel(list, orgId);
            if (!result) {
                throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25");
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/userEvaluationDetail.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u7ebf\u4e0b\u6210\u7ee9\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @ApiOperation(value="\u6210\u7ee9\u5bfc\u51fa")
    @GetMapping(value={"/export"})
    public void export(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestParam(required=false) String orgId) throws Exception {
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format("\u5e74\u5ea6\u6210\u7ee9\u4fe1\u606f-%s", date);
        ((ExamUserEvaluationManager)this.baseService).export(orgId, response, fileName);
    }

    @PostMapping(value={"/batchSettingYear"})
    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u5e74\u5ea6\u6700\u7ec8\u6210\u7ee9")
    public CommonResult<String> batchSettingYear(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SettingYearVo t) {
        log.info("\u8bbe\u7f6e\u5e74\u5ea6\u6700\u7ec8\u6210\u7ee9\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)t));
        boolean result = ((ExamUserEvaluationManager)this.baseService).batchSettingYear(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getSubjectInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u5e74\u8be5\u5c97\u4f4d\u8981\u8003\u6838\u7684\u8bfe\u76ee\uff08\u4f20\u5c97\u4f4did\u5c31\u53ef\u4ee5\uff09")
    public CommonResult getSubjectInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SettingYearVo t) {
        Assert.hasText((String)t.getPositionId(), (String)"\u8bf7\u5148\u9009\u62e9\u5c97\u4f4d");
        List<JSONObject> list = ((ExamUserEvaluationManager)this.baseService).getSubjectInfo(t);
        return CommonResult.success(list, (String)"");
    }

    @PostMapping(value={"/getPositionPaper"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5e74\u5ea6\u8be5\u8bfe\u76ee\u4e0b\u6240\u6709\u5e74\u5ea6\u8003\u6838\u6240\u6709\u8bd5\u5377\uff08\u4f20\u8bfe\u76eeid\u5c31\u53ef\u4ee5\uff09")
    public CommonResult getPositionPaper(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SettingYearVo t) {
        Assert.hasText((String)t.getSubjectId(), (String)"\u8bf7\u5148\u9009\u62e9\u8bfe\u76ee");
        List<JSONObject> list = ((ExamUserEvaluationManager)this.baseService).getPositionPaper(t);
        return CommonResult.success(list, (String)"");
    }

    @PostMapping(value={"/userQualityAnalyse"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eba\u5458\u7d20\u8d28\u60c5\u51b5\u5206\u6790")
    public PageList<UserExamVo> userQualityAnalyse(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return ((ExamUserEvaluationManager)this.baseService).userQualityAnalyse(queryFilter);
    }

    @PostMapping(value={"/setUserWorkEvaluation"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u8003\u751f\u804c\u4e1a\u6559\u80b2\u5206\u6570\u4ee5\u53ca\u603b\u4f53\u8bc4\u4ef7")
    public CommonResult setUserWorkEvaluation(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody ExamUserEvaluation t) {
        log.info("\u8bbe\u7f6e\u8003\u751f\u804c\u4e1a\u6559\u80b2\u5206\u6570\u4ee5\u53ca\u603b\u4f53\u8bc4\u4ef7\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)t)));
        boolean result = ((ExamUserEvaluationManager)this.baseService).setUserWorkEvaluation(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

