/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizTeachDataDao;
import com.artfess.data.manager.BizSubjectResourcesManager;
import com.artfess.data.manager.BizTeachDataManager;
import com.artfess.data.model.BizSubjectResources;
import com.artfess.data.model.BizTeachData;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizTeachDataManagerImpl
extends BaseManagerImpl<BizTeachDataDao, BizTeachData>
implements BizTeachDataManager {
    @Autowired
    private BizSubjectResourcesManager subjectResourcesManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(BizTeachData t) {
        boolean save = this.save((Object)t);
        if (save) {
            this.processInfo(t);
            return save;
        }
        return false;
    }

    private void processInfo(BizTeachData t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizSubjectResources::getTeachId, (Object)t.getId());
        this.subjectResourcesManager.remove((Wrapper)lambdaQueryWrapper);
        t.getSubjectResourcesList().forEach(bizSubjectResources -> bizSubjectResources.setTeachId(t.getId()));
        this.subjectResourcesManager.saveBatch(t.getSubjectResourcesList());
    }

    @Override
    public BizTeachData findById(String id) {
        BizTeachData bizTeachData = (BizTeachData)this.get((Serializable)((Object)id));
        if (null == bizTeachData) {
            return new BizTeachData();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizSubjectResources::getTeachId, (Object)id);
        List list = this.subjectResourcesManager.list((Wrapper)lambdaQueryWrapper);
        bizTeachData.setSubjectResourcesList(list);
        return bizTeachData;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizTeachData t) {
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processInfo(t);
            return save;
        }
        return false;
    }
}

