/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SysTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.examine.dao.ExamEquipmentSysDao;
import com.artfess.examine.dao.ExamPosSysDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamPosSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamEquipmentSysManagerImpl
extends BaseManagerImpl<ExamEquipmentSysDao, ExamEquipmentSys>
implements ExamEquipmentSysManager {
    @Resource
    private ExamPosSysDao posSysDao;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;

    @Override
    public List<ExamSubjectType> getTree(ExamEquipmentSys entity) {
        ArrayList treeList = Lists.newArrayList();
        List<ExamSubjectType> orgs = this.subjectInfoDao.getOrgList();
        orgs.forEach(org -> org.setType("1"));
        treeList.addAll(orgs);
        List<ExamSubjectType> posts = this.subjectInfoDao.getPositions();
        posts.forEach(post -> {
            if (StringUtil.isNotEmpty((String)post.getSysId())) {
                post.setParentId(post.getSysId());
            } else {
                post.setParentId(post.getOrgId());
            }
            post.setType("3");
        });
        treeList.addAll(posts);
        List tree = BeanUtils.listToTree((List)treeList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindPosAndUserType(ExamEquipmentSys entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sys_id_", (Object)entity.getId());
        this.posSysDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(entity.getPositonVos())) {
            return;
        }
        entity.getPositonVos().forEach(positionVo -> {
            ExamPosSys examPosSys = new ExamPosSys();
            examPosSys.setPosId(positionVo.getPositionId());
            examPosSys.setSysId(entity.getId());
            this.posSysDao.insert((Object)examPosSys);
        });
    }

    @Override
    public List<PositionVo> findByBindPos(String ids) {
        Assert.hasText((String)ids, (String)"\u8bf7\u9009\u62e9\u4e13\u4e1a\u88c5\u5907id");
        String[] split = ids.split(",");
        List<String> idList = Arrays.asList(split);
        List<PositionVo> list = this.posSysDao.findByBindPos(idList);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(ExamEquipmentSys t) {
        int insert = ((ExamEquipmentSysDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            this.processPosSysInfo(t);
            return true;
        }
        return false;
    }

    private void processPosSysInfo(ExamEquipmentSys entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sys_id_", (Object)entity.getId());
        this.posSysDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(entity.getPositonVos())) {
            return;
        }
        entity.getPositonVos().forEach(positionVo -> {
            ExamPosSys examPosSys = new ExamPosSys();
            String orgId = this.posSysDao.getOrgId(positionVo.getPositionId());
            ExamEquipmentSys sys = ((ExamEquipmentSysDao)this.baseMapper).findByNameAndOrgId(entity.getName(), orgId);
            if (null != sys) {
                throw new BaseException("\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5df2\u6709\u5f53\u524d\u88c5\u5907");
            }
            examPosSys.setOrgId(orgId);
            examPosSys.setPosId(positionVo.getPositionId());
            examPosSys.setSysId(entity.getId());
            this.posSysDao.insert((Object)examPosSys);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(ExamEquipmentSys t) {
        int insert = ((ExamEquipmentSysDao)this.baseMapper).updateById((Object)t);
        if (insert > 0) {
            this.processPosSysInfo(t);
            return true;
        }
        return false;
    }

    @Override
    public ExamEquipmentSys findById(String id) {
        ExamEquipmentSys examEquipmentSys = (ExamEquipmentSys)((Object)((ExamEquipmentSysDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PositionVo> positionVoList = this.posSysDao.getPositionInfo(id);
        examEquipmentSys.setPositonVos(positionVoList);
        return examEquipmentSys;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<ExamEquipmentSys> list) {
        list.forEach(sys -> {
            String orgId = this.posSysDao.findByOrgName(sys.getOrgName());
            ExamEquipmentSys examEquipmentSys = ((ExamEquipmentSysDao)this.baseMapper).findByNameAndOrgId(sys.getName(), orgId);
            if (null != examEquipmentSys) {
                throw new RuntimeException(sys.getName() + "\u5df2\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            sys.setType(SysTypeEnum.getType((String)sys.getType()));
            ((ExamEquipmentSysDao)this.baseMapper).insert(sys);
            if (!StringUtils.isEmpty((Object)sys.getPositonNames())) {
                List<String> positionIds = this.subjectInfoDao.getPositionIds(Arrays.asList(sys.getPositonNames().split(",")));
                positionIds.forEach(positionId -> {
                    ExamPosSys examPosSys = new ExamPosSys();
                    examPosSys.setOrgId(orgId);
                    examPosSys.setPosId((String)positionId);
                    examPosSys.setSysId(sys.getId());
                    this.posSysDao.insert((Object)examPosSys);
                });
            }
        });
        return true;
    }

    @Override
    public List<ExamSubjectInfo> getSubjectList(List<String> idList) {
        return ((ExamEquipmentSysDao)this.baseMapper).getSubjectList(idList);
    }

    @Override
    public JSONObject summary() {
        Long orgCount = this.posSysDao.getOrgCount();
        Long userCount = this.posSysDao.getUserCount();
        Long jlyCount = this.posSysDao.getJlyCount();
        Long sysCount = this.posSysDao.getSysCount();
        Long subjectCount = this.posSysDao.getSubjectCount();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgCount", (Object)orgCount);
        jsonObject.put("userCount", (Object)userCount);
        jsonObject.put("jlyCount", (Object)jlyCount);
        jsonObject.put("sysCount", (Object)sysCount);
        jsonObject.put("subjectCount", (Object)subjectCount);
        return jsonObject;
    }
}

