/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.CommonRedisKey;
import com.artfess.base.enums.PaperTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamImitateRecordManager;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.model.ExamImitateRecord;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.vo.ExamReqVo;
import com.artfess.examine.vo.MyExamInfoVo;
import com.artfess.examine.vo.QuestionsInfoVo;
import com.artfess.examine.vo.SubmitAnswerReqVo;
import com.artfess.redis.util.RedisLockUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u6a21\u62df\u8003\u8bd5"})
@RequestMapping(value={"/exam/imitate/record/"})
@ApiGroup(group={"group_biz"})
public class ExamImitateRecordController
extends BaseController<ExamImitateRecordManager, ExamImitateRecord> {
    private static final Logger log = LoggerFactory.getLogger(ExamImitateRecordController.class);
    @Autowired
    private ExamPaperBaseManager paperBaseManager;
    @Autowired
    private RedisLockUtils redisLockUtils;

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6a21\u62df\u8bd5\u5377")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamPaperBase t) {
        t.setType(PaperTypeEnum.simulation.getType());
        String id = this.paperBaseManager.updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u6a21\u62df\u8bd5\u5377")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamPaperBase t) {
        t.setType(PaperTypeEnum.simulation.getType());
        String id = this.paperBaseManager.createInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/findById/{id}"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6a21\u62df\u8bd5\u5377\u4fe1\u606f")
    public ExamPaperBase findById(@ApiParam(name="id", value="\u6a21\u62df\u8bd5\u5377id") @PathVariable String id) {
        return this.paperBaseManager.findById(id);
    }

    @GetMapping(value={"viewPaper/{id}"})
    @ApiOperation(value="\u9884\u89c8\u8bd5\u5377")
    public ExamPaperBase viewPaper(@ApiParam(name="id", value="\u6a21\u62df\u8bd5\u5377id") @PathVariable String id) {
        return this.paperBaseManager.viewPaper(id);
    }

    @GetMapping(value={"/getUserRecord/{id}"})
    @ApiOperation(value="\u7b54\u5377\u8bb0\u5f55")
    public MyExamInfoVo getUserRecord(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        MyExamInfoVo myExamInfoVo = ((ExamImitateRecordManager)this.baseService).getUserRecord(id);
        return myExamInfoVo;
    }

    @PostMapping(value={"/startExam"})
    @ApiOperation(value="\u5f00\u59cb\u8003\u8bd5-\u8fdb\u5165\u6211\u7684\u8bd5\u5377\u5f00\u59cb\u7b54\u9898")
    public MyExamInfoVo startExam(@RequestBody ExamReqVo reqVo) {
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        reqVo.setUserId(currentUserId);
        log.info("\u5f00\u59cb\u8003\u8bd5\u300b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        MyExamInfoVo myExamInfoVo = ((ExamImitateRecordManager)this.baseService).startExam(reqVo);
        log.info("\u5f00\u59cb\u8003\u8bd5\u300b\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)myExamInfoVo));
        return myExamInfoVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/submitAnswer"})
    @ApiOperation(value="\u63d0\u4ea4\u7b54\u5377")
    public CommonResult submitAnswer(@RequestBody SubmitAnswerReqVo vo) {
        Assert.hasText((String)vo.getRecordId(), (String)"\u8003\u8bd5\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u63d0\u4ea4\u7b54\u5377\u300b\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        CommonRedisKey commonLockType = CommonRedisKey.SUBMIT_ANSWER_KEY;
        boolean lock = this.redisLockUtils.tryLock(commonLockType.name() + ":" + vo.getRecordId(), 10L, TimeUnit.SECONDS);
        if (!lock) {
            throw new RuntimeException("\u7cfb\u7edf\u7e41\u5fd9");
        }
        try {
            String currentUserId = AuthenticationUtil.getCurrentUserId();
            vo.setUserId(currentUserId);
            ((ExamImitateRecordManager)this.baseService).submitAnswer(vo);
            CommonResult commonResult = new CommonResult();
            return commonResult;
        }
        catch (BaseException e) {
            log.error("\u63d0\u4ea4\u7b54\u5377:{}", (Object)e.getMessage());
            CommonResult commonResult = new CommonResult();
            return commonResult;
        }
        finally {
            this.redisLockUtils.unLock(commonLockType.name() + ":" + vo.getRecordId());
        }
    }

    @PostMapping(value={"/trainingPaperQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bad\u7ec3\u6210\u7ee9")
    public PageList<ExamImitateRecord> trainingPaperQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamImitateRecord> queryFilter) {
        queryFilter.addFilter("user_id_", (Object)AuthenticationUtil.getCurrentUserId(), QueryOP.EQUAL);
        return ((ExamImitateRecordManager)this.baseService).trainingPaperQuery(queryFilter);
    }

    @GetMapping(value={"/errorQuestionsList/{id}"})
    @ApiOperation(value="\u9519\u9898\u672c")
    public List<QuestionsInfoVo> errorQuestionsList(@ApiParam(name="id", value="\u8bd5\u5377id") @PathVariable String id) {
        List<QuestionsInfoVo> list = ((ExamImitateRecordManager)this.baseService).errorQuestionsList(id);
        return list;
    }
}

