/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.enums.PaperWayTypeEnum;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.examine.dao.ExamPaperTaskDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.manager.ExamPaperTaskManager;
import com.artfess.examine.manager.ExamTaskManager;
import com.artfess.examine.manager.ExamUserRecordDetailManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamPaperTask;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamTask;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.model.ExamUserRecordDetail;
import com.artfess.examine.vo.UserInfoVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperTaskManagerImpl
extends BaseManagerImpl<ExamPaperTaskDao, ExamPaperTask>
implements ExamPaperTaskManager {
    @Autowired
    private ExamPaperBaseManager paperBaseManager;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Autowired
    private ExamTaskManager taskManager;
    @Autowired
    private ExamUserRecordDetailManager userRecordDetailManager;
    @Autowired
    private ExamUserRecordManager userRecordManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createTask(ExamPaperTask t) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateTask(ExamPaperTask t) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void startTask(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u53d1\u5e03\u7684\u4efb\u52a1");
        ExamPaperTask examPaperTask = (ExamPaperTask)((Object)((ExamPaperTaskDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examPaperTask), (String)"\u53d1\u5e03\u7684\u4efb\u52a1\u4e0d\u5b58\u5728");
        Assert.hasText((String)examPaperTask.getPaperId(), (String)"\u8be5\u4efb\u52a1\u53ea\u6709\u5173\u8054\u8bd5\u5377\u540e\u624d\u80fd\u8fdb\u884c\u53d1\u5e03");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseManager.getBaseMapper().selectById((Serializable)((Object)examPaperTask.getPaperId())));
        Assert.notNull((Object)((Object)examPaperBase), (String)"\u5173\u8054\u7684\u8bd5\u5377\u4e0d\u5b58\u5728");
        if ("1".equals(examPaperTask.getStatus())) {
            throw new RuntimeException("\u4efb\u52a1\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u5e03");
        }
        ExamSubjectInfo examSubjectInfo = (ExamSubjectInfo)((Object)this.subjectInfoDao.selectById((Serializable)((Object)examPaperBase.getSubjectId())));
        Assert.notNull((Object)((Object)examSubjectInfo), (String)"\u5173\u8054\u7684\u8003\u8bd5\u8bfe\u76ee\u4e0d\u5b58\u5728");
        Iterable userInfoVoList = null;
        ArrayList taskList = Lists.newArrayList();
        userInfoVoList.forEach(user -> {
            ExamTask task = new ExamTask();
            task.setReceiveUser(user.getUserId());
            task.setTaskId(id);
            taskList.add(task);
        });
        this.taskManager.saveBatch(taskList);
        examPaperTask.setStatus("1");
        ((ExamPaperTaskDao)this.baseMapper).updateById((Object)examPaperTask);
        this.processPaperSettingInfo((List<UserInfoVo>)userInfoVoList, examPaperBase, id);
    }

    private void processPaperSettingInfo(List<UserInfoVo> userInfoVoList, ExamPaperBase examPaperBase, String taskId) {
        if (PaperWayTypeEnum.sjcj.getType().equals(examPaperBase.getWayType())) {
            userInfoVoList.forEach(userVo -> {
                List<ExamQuestionsInfo> examQuestionsInfos = this.paperBaseManager.processQuestionList(examPaperBase);
                this.createUserRecord((UserInfoVo)userVo, examQuestionsInfos, examPaperBase, taskId);
            });
        } else {
            List<ExamQuestionsInfo> examQuestionsInfos = this.paperBaseManager.processQuestionList(examPaperBase);
            userInfoVoList.forEach(userVo -> this.createUserRecord((UserInfoVo)userVo, examQuestionsInfos, examPaperBase, taskId));
        }
    }

    private void createUserRecord(UserInfoVo userVo, List<ExamQuestionsInfo> examQuestionsInfos, ExamPaperBase examPaperBase, String taskId) {
        ArrayList records = Lists.newArrayList();
        ExamUserRecord examUserRecord = new ExamUserRecord();
        examUserRecord.setPaperId(taskId);
        examUserRecord.setUserId(userVo.getUserId());
        examUserRecord.setUserName(userVo.getUserName());
        examUserRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
        this.userRecordManager.save((Object)examUserRecord);
        examQuestionsInfos.forEach(question -> {
            ExamUserRecordDetail userRecordDetail = new ExamUserRecordDetail();
            userRecordDetail.setRecordId(examUserRecord.getId());
            userRecordDetail.setQuestionId(question.getId());
            userRecordDetail.setQuestionType(question.getType());
            userRecordDetail.setRightKey(question.getRightOption());
            userRecordDetail.setScore(question.getScore());
            records.add(userRecordDetail);
        });
        if (!CollectionUtils.isEmpty((Collection)records)) {
            this.userRecordDetailManager.saveBatch(records);
        }
    }
}

