/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.manager.BizRegulatoryFileManager;
import com.artfess.data.model.BizRegulatoryFile;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u6cd5\u89c4\u6587\u4ef6"})
@RequestMapping(value={"/biz/regulatory/file/"})
@ApiGroup(group={"group_biz"})
public class BizRegulatoryFileController
extends BaseController<BizRegulatoryFileManager, BizRegulatoryFile> {
    private static final Logger log = LoggerFactory.getLogger(BizRegulatoryFileController.class);

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="knowledgeTypeId", required=false) String knowledgeTypeId) {
        try {
            Assert.hasText((String)knowledgeTypeId, (String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
            ExcelUtils excelUtil = new ExcelUtils(BizRegulatoryFile.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            list.forEach(data -> data.setKnowledgeTypeId(knowledgeTypeId));
            ((BizRegulatoryFileManager)this.baseService).saveBatch(list);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizRegulatoryFile> queryFilter) throws Exception {
        PageList page = ((BizRegulatoryFileManager)this.baseService).query(queryFilter);
        ExcelUtils util = new ExcelUtils(BizRegulatoryFile.class);
        util.exportExcel(response, request, page.getRows(), "\u6cd5\u89c4\u6587\u4ef6\u6570\u636e");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u77e5\u8bc6\u6570\u636e/\u6cd5\u89c4\u6587\u4ef6.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u6cd5\u89c4\u6587\u4ef6\u6570\u636e\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }
}

