/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.dao.ExamYearAssessmentSubDao;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.manager.ExamYearAssessmentSubManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.model.ExamYearAssessmentSub;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExamYearAssessmentSubManagerImpl
extends BaseManagerImpl<ExamYearAssessmentSubDao, ExamYearAssessmentSub>
implements ExamYearAssessmentSubManager {
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Autowired
    private ExamUserEvaluationManager userEvaluationManager;
    @Autowired
    private ExamUserEvaluationDetailManager userEvaluationDetailManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(ExamYearAssessmentSub t) {
        Assert.notEmpty(t.getSubjectInfoList(), (String)"\u8bf7\u9009\u62e9\u8981\u8003\u6838\u7684\u8bfe\u76ee");
        String subjectIds = t.getSubjectInfoList().stream().map(ExamSubjectInfo::getId).collect(Collectors.joining(",", "", ""));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"year_", (Object)t.getYear());
        queryWrapper.eq((Object)"position_id_", (Object)t.getPositionId());
        queryWrapper.in((Object)"subject_ids_", new Object[]{subjectIds});
        List examYearAssessmentSubs = ((ExamYearAssessmentSubDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)examYearAssessmentSubs)) {
            throw new BaseException("\u8be5\u5c97\u4f4d\u4eca\u5e74\u5df2\u914d\u7f6e\u8003\u6838\u8bfe\u76ee\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f");
        }
        ArrayList list = Lists.newArrayList();
        t.getSubjectInfoList().forEach(subjectInfo -> {
            ExamYearAssessmentSub sub = new ExamYearAssessmentSub();
            sub.setPositionId(t.getPositionId());
            sub.setSubjectIds(subjectInfo.getId());
            sub.setSubjectName(subjectInfo.getName());
            sub.setYear(t.getYear());
            list.add(sub);
        });
        boolean b = this.saveBatch(list);
        if (b) {
            this.executorService.execute(() -> {
                try {
                    List<UserInfoVo> userInfoList = ((ExamYearAssessmentSubDao)this.baseMapper).getUserInfoList(t.getPositionId());
                    list.forEach(sub -> this.processUserEvaluation(userInfoList, (ExamYearAssessmentSub)((Object)((Object)sub))));
                }
                catch (Exception e) {
                    this.log.error("\u521b\u5efa\u5e74\u5ea6\u8003\u6838\u8bb0\u5f55\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
        return b;
    }

    private void processUserEvaluation(List<UserInfoVo> userInfoList, ExamYearAssessmentSub t) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)t.getPositionId());
        query.eq((Object)"year_", (Object)t.getYear());
        List examUserEvaluations = this.userEvaluationManager.getBaseMapper().selectList((Wrapper)query);
        Map<Object, Object> userEvaluationMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)examUserEvaluations)) {
            userEvaluationMap = examUserEvaluations.stream().collect(Collectors.toMap(item -> item.getUserId(), item -> item));
        }
        ArrayList list = Lists.newArrayList();
        ArrayList detailList = Lists.newArrayList();
        for (UserInfoVo userInfoVo : userInfoList) {
            ExamUserEvaluation examUserEvaluation = null;
            if (!CollectionUtils.isEmpty((Map)userEvaluationMap) && userEvaluationMap.containsKey(userInfoVo.getUserId())) {
                examUserEvaluation = (ExamUserEvaluation)((Object)userEvaluationMap.get(userInfoVo.getUserId()));
                examUserEvaluation.setNotCount(examUserEvaluation.getNotCount() + 1);
                examUserEvaluation.setTotalCount(examUserEvaluation.getTotalCount() + 1);
                examUserEvaluation.setSubjectId(examUserEvaluation.getSubjectId() + "," + t.getSubjectIds());
                examUserEvaluation.setSubjectName(examUserEvaluation.getSubjectName() + "," + t.getSubjectName());
            } else {
                examUserEvaluation = new ExamUserEvaluation();
                examUserEvaluation.setYear(t.getYear());
                examUserEvaluation.setPositionId(t.getPositionId());
                examUserEvaluation.setUserId(userInfoVo.getUserId());
                examUserEvaluation.setUserName(userInfoVo.getUserName());
                examUserEvaluation.setInCount(0);
                examUserEvaluation.setNotCount(1);
                examUserEvaluation.setTotalCount(1);
                examUserEvaluation.setSubjectName(t.getSubjectName());
                examUserEvaluation.setSubjectId(t.getSubjectIds());
            }
            list.add(examUserEvaluation);
            ExamUserEvaluationDetail examUserEvaluationDetail = new ExamUserEvaluationDetail();
            examUserEvaluationDetail.setPositionId(examUserEvaluation.getPositionId());
            examUserEvaluationDetail.setSubjectId(t.getSubjectIds());
            examUserEvaluationDetail.setSubjectName(t.getSubjectName());
            examUserEvaluationDetail.setType("1");
            examUserEvaluationDetail.setUserId(examUserEvaluation.getUserId());
            examUserEvaluationDetail.setUserName(examUserEvaluation.getUserName());
            examUserEvaluationDetail.setYear(examUserEvaluation.getYear());
            detailList.add(examUserEvaluationDetail);
        }
        this.userEvaluationManager.saveOrUpdateBatch(list);
        this.userEvaluationDetailManager.saveBatch(detailList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(ExamYearAssessmentSub t) {
        Assert.notEmpty(t.getSubjectInfoList(), (String)"\u8bf7\u9009\u62e9\u8981\u8003\u6838\u7684\u8bfe\u76ee");
        ExamYearAssessmentSub sub = (ExamYearAssessmentSub)((Object)((ExamYearAssessmentSubDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)sub.getPositionId());
        query.eq((Object)"year_", (Object)sub.getYear());
        query.like((Object)"subject_id_", (Object)sub.getSubjectIds());
        query.gt((Object)"in_count_", (Object)0);
        List examUserEvaluations = this.userEvaluationManager.getBaseMapper().selectList((Wrapper)query);
        if (!CollectionUtils.isEmpty((Collection)examUserEvaluations)) {
            throw new BaseException("\u5f53\u524d\u8981\u4fee\u6539\u7684\u79d1\u76ee\u52a0\u5165\u5e74\u5ea6\u8003\u6838\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"year_", (Object)t.getYear());
        queryWrapper.eq((Object)"position_id_", (Object)t.getPositionId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List examYearAssessmentSubs = ((ExamYearAssessmentSubDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)examYearAssessmentSubs)) {
            throw new BaseException("\u8be5\u5c97\u4f4d\u4eca\u5e74\u5df2\u914d\u7f6e\u8003\u6838\u8bfe\u76ee\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f");
        }
        String subjectNames = t.getSubjectInfoList().stream().map(ExamSubjectInfo::getName).collect(Collectors.joining(",", "", ""));
        String subjectIds = t.getSubjectInfoList().stream().map(ExamSubjectInfo::getId).collect(Collectors.joining(",", "", ""));
        t.setSubjectIds(subjectIds);
        t.setSubjectName(subjectNames);
        boolean b = this.updateById((Object)t);
        if (b) {
            this.executorService.execute(() -> {
                try {
                    if (!sub.getSubjectIds().equals(t.getSubjectIds())) {
                        List<UserInfoVo> userInfoList = ((ExamYearAssessmentSubDao)this.baseMapper).getUserInfoList(t.getPositionId());
                        this.updateUserEvaluation(userInfoList, t, sub);
                    }
                }
                catch (Exception e) {
                    this.log.error("\u521b\u5efa\u5e74\u5ea6\u8003\u6838\u8bb0\u5f55\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
        return b;
    }

    private void updateUserEvaluation(List<UserInfoVo> userInfoList, ExamYearAssessmentSub t, ExamYearAssessmentSub sub) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"position_id_", (Object)t.getPositionId());
        query.eq((Object)"year_", (Object)t.getYear());
        List examUserEvaluations = this.userEvaluationManager.getBaseMapper().selectList((Wrapper)query);
        Map<Object, Object> userEvaluationMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)examUserEvaluations)) {
            userEvaluationMap = examUserEvaluations.stream().collect(Collectors.toMap(item -> item.getUserId(), item -> item));
        }
        ArrayList list = Lists.newArrayList();
        ArrayList detailList = Lists.newArrayList();
        for (UserInfoVo userInfoVo : userInfoList) {
            ExamUserEvaluation examUserEvaluation = null;
            if (!CollectionUtils.isEmpty((Map)userEvaluationMap) && userEvaluationMap.containsKey(userInfoVo.getUserId())) {
                examUserEvaluation = (ExamUserEvaluation)((Object)userEvaluationMap.get(userInfoVo.getUserId()));
                examUserEvaluation.setSubjectId(examUserEvaluation.getSubjectId().replace(sub.getSubjectIds(), t.getSubjectIds()));
                examUserEvaluation.setSubjectName(examUserEvaluation.getSubjectName().replace(sub.getSubjectName(), t.getSubjectName()));
            } else {
                examUserEvaluation = new ExamUserEvaluation();
                examUserEvaluation.setYear(t.getYear());
                examUserEvaluation.setPositionId(t.getPositionId());
                examUserEvaluation.setUserId(userInfoVo.getUserId());
                examUserEvaluation.setUserName(userInfoVo.getUserName());
                examUserEvaluation.setInCount(0);
                examUserEvaluation.setNotCount(1);
                examUserEvaluation.setTotalCount(1);
                examUserEvaluation.setSubjectName(t.getSubjectName());
                examUserEvaluation.setSubjectId(t.getSubjectIds());
            }
            list.add(examUserEvaluation);
        }
        this.userEvaluationManager.saveOrUpdateBatch(list);
        this.userEvaluationDetailManager.saveBatch(detailList);
    }

    @Override
    public ExamYearAssessmentSub findById(String id) {
        ExamYearAssessmentSub sub = (ExamYearAssessmentSub)((Object)((ExamYearAssessmentSubDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id_", Arrays.asList(sub.getSubjectIds().split(",")));
        List examSubjectInfos = this.subjectInfoDao.selectList((Wrapper)queryWrapper);
        sub.setSubjectInfoList(examSubjectInfos);
        return sub;
    }

    @Override
    public List<ExamSubjectInfo> findByPositionId(String positionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"year_", (Object)String.valueOf(LocalDateTime.now().getYear()));
        queryWrapper.eq((Object)"position_id_", (Object)positionId);
        ExamYearAssessmentSub sub = (ExamYearAssessmentSub)((Object)((ExamYearAssessmentSubDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        List<String> strings = Arrays.asList(sub.getSubjectIds().split(","));
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id_", strings);
        List examSubjectInfos = this.subjectInfoDao.selectList((Wrapper)query);
        return examSubjectInfos;
    }

    @Override
    public PageList<ExamSubjectInfo> findByPage(QueryFilter<ExamSubjectInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamSubjectInfo> result = ((ExamYearAssessmentSubDao)this.baseMapper).findByPage((IPage<ExamYearAssessmentSub>)this.convert2IPage(pageBean), (Wrapper<ExamYearAssessmentSub>)this.convert2Wrapper(queryFilter, this.currentModelClass()), queryFilter.getParams());
        return new PageList(result);
    }
}

