/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataPermission;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.PaperStatusEnum;
import com.artfess.base.enums.PaperTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u57fa\u7840\u6570\u636e-\u8bd5\u5377\u7ba1\u7406"})
@RequestMapping(value={"/exam/paper/base/"})
@ApiGroup(group={"group_biz"})
public class ExamPaperBaseController
extends BaseController<ExamPaperBaseManager, ExamPaperBase> {
    private static final Logger log = LoggerFactory.getLogger(ExamPaperBaseController.class);
    @Resource
    BaseContext baseContext;
    @Autowired
    private ExamUserRecordManager userRecordManager;

    @DataPermission
    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ExamPaperBase> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamPaperBase> queryFilter) {
        IUser currentUser = ContextUtil.getCurrentUser();
        AtomicBoolean flag = new AtomicBoolean(false);
        AtomicReference paperStatus = new AtomicReference();
        queryFilter.getQuerys().forEach(queryField -> {
            if ("type_".equals(queryField.getProperty()) && PaperTypeEnum.simulation.getType().equals(queryField.getValue())) {
                flag.set(true);
            }
            if ("paperStatus".equals(queryField.getProperty())) {
                paperStatus.set(queryField.getValue() + "");
            }
        });
        if (PaperStatusEnum.notRelease.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.status_", (Object)PaperStatusEnum.notRelease.getType(), QueryOP.EQUAL);
        } else if (PaperStatusEnum.inTets.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
            queryFilter.addFilter("s.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        } else if (PaperStatusEnum.finish.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("s.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
        }
        if (!StringUtils.isEmpty(paperStatus.get())) {
            queryFilter.getQuerys().removeIf(s -> "paperStatus".equals(s.getProperty()));
        }
        if (flag.get() && !currentUser.isAdmin()) {
            queryFilter.addFilter("b.create_by_", (Object)currentUser.getUserId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("b.IS_DELE_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("b.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamPaperBaseManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) ExamPaperBase t) {
        t.setType(PaperTypeEnum.formal.getType());
        String id = ((ExamPaperBaseManager)this.baseService).createInfo(t);
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53\uff08\u672a\u53d1\u5e03\u4e4b\u524d\u663e\u793a\u8be5\u6309\u94ae\uff09")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) ExamPaperBase t) {
        t.setType(PaperTypeEnum.formal.getType());
        String id = ((ExamPaperBaseManager)this.baseService).updateInfo(t);
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public ExamPaperBase getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamPaperBaseManager)this.baseService).findById(id);
    }

    @GetMapping(value={"viewPaper/{id}"})
    @ApiOperation(value="\u9884\u89c8\u8bd5\u5377")
    public ExamPaperBase viewPaper(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((ExamPaperBaseManager)this.baseService).viewPaper(id);
    }

    @ApiOperation(value="\u53d1\u5e03\u8003\u8bd5")
    @GetMapping(value={"startPaper/{id}"})
    public CommonResult<String> startTask(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        ((ExamPaperBaseManager)this.baseService).startPaper(id);
        return new CommonResult();
    }

    @PostMapping(value={"/addUser"})
    @ApiOperation(value="\u8bd5\u5377\u6dfb\u52a0\u8003\u751f\uff08\u672a\u53d1\u5e03\u4e0d\u663e\u793a\u8be5\u529f\u80fd\u3001\u53ea\u63d0\u4ea4\u65b0\u589e\u7684\u8003\u751f\u4fe1\u606f\uff09")
    public CommonResult<String> addUser(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody ExamPaperBase t) {
        ((ExamPaperBaseManager)this.baseService).addUser(t);
        return new CommonResult();
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            try {
                ExcelUtils excelUtil = new ExcelUtils(ExamPaperBase.class);
                List list = excelUtil.importExcel(null, file.getInputStream());
                boolean b = ((ExamPaperBaseManager)this.baseService).saveBatch(list);
                if (!b) {
                    return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
                }
            }
            catch (Exception e) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
            }
            return new CommonResult();
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamPaperBase> queryFilter) throws Exception {
        PageList page = ((ExamPaperBaseManager)this.baseService).query(queryFilter);
        ExcelUtils util = new ExcelUtils(ExamPaperBase.class);
        util.exportExcel(response, request, page.getRows(), "\u8bd5\u5377\u4fe1\u606f");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u5bfc\u5165\u6a21\u677f.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("b.id_", Arrays.asList(ids), QueryOP.IN);
        PageBean pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        queryFilter.setPageBean(pageBean);
        PageList<ExamPaperBase> byPage = ((ExamPaperBaseManager)this.baseService).findByPage((QueryFilter<ExamPaperBase>)queryFilter);
        byPage.getRows().forEach(examPaperBase -> {
            boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)examPaperBase.getPlanEndTime());
            if (dateEquals && !PaperStatusEnum.notRelease.getType().equals(examPaperBase.getStatus())) {
                examPaperBase.setStatus(PaperStatusEnum.inTets.getType());
            } else if (!dateEquals && !PaperStatusEnum.notRelease.getType().equals(examPaperBase.getStatus())) {
                examPaperBase.setStatus(PaperStatusEnum.finish.getType());
            }
            if (!PaperStatusEnum.notRelease.getType().equals(examPaperBase.getStatus())) {
                throw new BaseException(examPaperBase.getName() + "\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\uff01");
            }
        });
        boolean result = ((ExamPaperBaseManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(ExamUserRecord::getPaperId, Arrays.asList(ids));
        this.userRecordManager.remove((Wrapper)lambdaQueryWrapper);
        return new CommonResult();
    }

    @ApiOperation(value="\u83b7\u53d6\u4eca\u5e74\u8be5\u8bfe\u76ee\u662f\u5426\u5df2\u7ecf\u8bbe\u7f6e\u8fc7\u6700\u7ec8\u6210\u7ee9")
    @GetMapping(value={"getEndStatus/{subjectId}"})
    public CommonResult<String> getEndStatus(@ApiParam(name="subjectId", value="\u8bfe\u76eeid") @PathVariable String subjectId) {
        Long count = ((ExamPaperBaseManager)this.baseService).getEndStatus(subjectId);
        if (count > 0L) {
            return CommonResult.success(null, (String)"\u4eca\u5e74\u8be5\u8bfe\u76ee\u5df2\u8bbe\u7f6e\u8fc7\u6700\u7ec8\u6210\u7ee9");
        }
        return CommonResult.success(null, (String)"\u4eca\u5e74\u8be5\u8bfe\u76ee\u672a\u8bbe\u7f6e\u8fc7\u6700\u7ec8\u6210\u7ee9");
    }
}

