/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.consumers;

import com.artfess.base.constants.CodePrefix;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.examine.dao.ExamUserRecordDao;
import com.artfess.examine.model.ExamUserRecord;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class RedisTaskListener
extends KeyExpirationEventMessageListener {
    private static final Logger log = LoggerFactory.getLogger(RedisTaskListener.class);
    @Resource
    private ExamUserRecordDao examUserRecordDao;

    public RedisTaskListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        String expiredKey = message.toString();
        if (!expiredKey.contains(CodePrefix.PAPER_TASK_KEY.getKey())) {
            return;
        }
        String[] expiredKeyArr = expiredKey.split(":");
        if (expiredKeyArr.length < 1) {
            return;
        }
        String recordId = expiredKeyArr[expiredKeyArr.length - 1];
        ExamUserRecord record = (ExamUserRecord)((Object)this.examUserRecordDao.selectById((Serializable)((Object)recordId)));
        if (null != record && QuestionStateEnum.inTest.getType().equals(record.getStatus())) {
            record.setStatus(QuestionStateEnum.haveTest.getType());
            record.setEndTime(LocalDateTime.now());
            long time = System.currentTimeMillis() - record.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            String answerTime = formatter.format(time);
            record.setAnswerTime(answerTime);
            this.examUserRecordDao.updateById((Object)record);
            log.info("\u8003\u8bd5\u8d85\u65f6\uff0c\u81ea\u52a8\u63d0\u4ea4\u8bd5\u5377,\u8003\u751f\uff1a{},\u8003\u8bd5\u8bb0\u5f55id\uff1a{}", (Object)record.getUserName(), (Object)record.getId());
        }
    }
}

