/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.dao.BizUserCheckDao;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizUserCheckManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserCheck;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizUserCheckManagerImpl
extends BaseManagerImpl<BizUserCheckDao, BizUserCheck>
implements BizUserCheckManager {
    @Autowired
    private BizExamPlanManager examPlanManager;

    @Override
    public void importList(List<BizUserCheck> list, String planId) {
        Assert.hasText((String)planId, (String)"\u8bf7\u9009\u62e9\u8981\u8003\u52e4\u7684\u8bad\u7ec3\u8ba1\u5212");
        BizExamPlan bizExamPlan = (BizExamPlan)this.examPlanManager.get((Serializable)((Object)planId));
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8bfe\u76ee\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.eq((Object)"plan_id_", (Object)planId);
        List userChecks = this.list((Wrapper)queryWrapper);
        ArrayList updateUsers = Lists.newArrayList();
        Map<String, List<BizUserCheck>> dMap = userChecks.stream().collect(Collectors.groupingBy(BizUserCheck::getUserName));
        list.forEach(baseData -> {
            Assert.notNull((Object)baseData.getCheckDate(), (String)"\u8bf7\u586b\u5199\u8003\u52e4\u65e5\u671f");
            Assert.hasText((String)baseData.getUserName(), (String)"\u8bf7\u586b\u5199\u8003\u751f\u4fe1\u606f");
            if (CollectionUtils.isEmpty((Map)dMap) || null == dMap.get(baseData.getUserName())) {
                return;
            }
            List userCheckList = (List)dMap.get(baseData.getUserName());
            Map<String, BizUserCheck> detailMap = userCheckList.stream().collect(Collectors.toMap(item -> item.getCheckDate(), item -> item));
            if (null != detailMap && null != detailMap.get(baseData.getCheckDate())) {
                BizUserCheck userCheck = detailMap.get(baseData.getCheckDate());
                userCheck.setStatus("1");
                updateUsers.add(userCheck);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)updateUsers)) {
            this.saveOrUpdateBatch(updateUsers);
        }
    }

    @Override
    public PageList<BizUserCheck> findByPage(QueryFilter<BizUserCheck> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizUserCheck> result = ((BizUserCheckDao)this.baseMapper).findByPage((IPage<BizUserCheck>)this.convert2IPage(pageBean), (Wrapper<BizUserCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

