package com.artfess.portal.persistence.manager;



import com.artfess.portal.exception.RedisConnectException;
import com.artfess.portal.params.RedisInfo;

import java.util.List;
import java.util.Map;

public interface RedisService {

	/**
	 * 获取 redis 的详细信息
	 *
	 * @return List
	 */
	List<RedisInfo> getRedisInfo() throws RedisConnectException;

	/**
	 * 获取 redis key 数量
	 *
	 * @return Map
	 */
	Map<String, Object> getKeysSize() throws RedisConnectException;

	/**
	 * 获取 redis 内存信息
	 *
	 * @return Map
	 */
	Map<String, Object> getMemoryInfo() throws RedisConnectException;

	/**
	 * 获取所有的key或者查找key
	 * @param key
	 * @return
	 */
	public Map<String, Object> getAllCache(String key);

	/**
	 * 根据key删除缓存  key可以传一个或者多个
	 * @param cacheKey
	 * @return
	 */
	public String deleteCache(String... cacheKey);

}
