/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.util;

import com.alibaba.fastjson.JSON;
import com.artfess.base.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtil {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasKeyLike(String key) {
        try {
            Set keys = this.redisTemplate.keys((Object)(key + "*"));
            return keys.size() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object value = this.redisTemplate.opsForValue().get((Object)key);
        if (value != null) {
            String temp;
            try {
                temp = new String();
                temp = String.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
            if (clazz.isPrimitive()) {
                if (String.class.isAssignableFrom(clazz)) {
                    return (T)temp;
                }
                if (Integer.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Integer(temp);
                }
                if (Long.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Long(temp);
                }
                if (Boolean.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Boolean(temp);
                }
                if (Double.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Double(temp);
                }
                if (Float.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Float(temp);
                }
                if (Byte.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Byte(temp);
                }
                if (Short.TYPE.isAssignableFrom(clazz)) {
                    return (T)new Short(temp);
                }
                throw new RuntimeException("unsupport type:type=" + clazz.getName() + "value=" + temp);
            }
            try {
                return (T)JSON.parseObject((String)temp, clazz);
            }
            catch (Exception e) {
                return (T)temp;
            }
        }
        return null;
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void delLike(String prex) {
        Set keys = this.redisTemplate.keys((Object)(prex + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Map<String, Object> getAllCaches(String key) {
        Set keys = null;
        keys = StringUtils.isBlank((CharSequence)key) ? this.redisTemplate.keys((Object)"*") : this.redisTemplate.keys((Object)(key + "*"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        keys.forEach(s -> {
            DataType type = this.redisTemplate.type(s);
            String code = type.code();
            System.out.println(code);
            if (code.equals("list")) {
                map.put((String)s, this.lGet((String)s, 0L, -1L));
            } else if (code.equals("hash")) {
                map.put((String)s, this.hmget((String)s));
            } else if (code.equals("set")) {
                map.put((String)s, this.sGet((String)s));
            } else if (code.equals("zset")) {
                map.put((String)s, this.redisTemplate.opsForZSet().range(s, 0L, -1L));
            } else {
                map.put((String)s, this.get((String)s));
            }
        });
        return map;
    }

    public Map<String, Object> getAllCache(String key) {
        Set keys = null;
        keys = StringUtil.isEmpty((String)key) ? this.redisTemplate.keys((Object)"*") : this.redisTemplate.keys((Object)(key + "*"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        keys.forEach(s -> map.put((String)s, this.get((String)s)));
        return map;
    }
}

