/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import com.artfess.base.util.DateUtils;
import com.artfess.base.util.FileTypeUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.string.Convert;
import com.artfess.poi.annotation.Excel;
import com.artfess.poi.annotation.Excels;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.poi.util.ImageUtils;
import com.artfess.poi.util.ReflectUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExcelTool<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final int sheetSize = 65536;
    private String sheetName;
    private Excel.Type type;
    private Workbook wb;
    private Sheet sheet;
    private Map<String, CellStyle> styles;
    private List<T> list;
    private List<Object[]> fields;
    private short maxHeight;
    private Map<Integer, Double> statistics = new HashMap<Integer, Double>();
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("######0.00");
    private List<String> selectedField;
    public Class<T> clazz;

    public void setSelectedField(List<String> selectedField) {
        this.selectedField = selectedField;
    }

    public ExcelTool(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void init(List<T> list, String sheetName, Excel.Type type) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        this.list = list;
        this.sheetName = sheetName;
        this.type = type;
        this.createExcelField();
        this.createWorkbook();
    }

    public List<T> importExcel(InputStream is, Integer headRowNum, Integer rowNum) throws Exception {
        if (headRowNum == null || headRowNum < 1) {
            headRowNum = 1;
        }
        if (rowNum == null || rowNum < 1) {
            rowNum = 2;
        }
        return this.importExcel("", is, headRowNum, rowNum);
    }

    public List<T> importExcel(InputStream is) throws Exception {
        return this.importExcel("", is);
    }

    public List<T> importExcel(String sheetName, InputStream is) throws Exception {
        this.type = Excel.Type.IMPORT;
        this.wb = WorkbookFactory.create((InputStream)is);
        ArrayList<Object> list = new ArrayList<Object>();
        Sheet sheet = null;
        sheet = StringUtil.isNotEmpty((String)sheetName) ? this.wb.getSheet(sheetName) : this.wb.getSheetAt(0);
        if (sheet == null) {
            throw new IOException("\u6587\u4ef6sheet\u4e0d\u5b58\u5728");
        }
        int rows = sheet.getLastRowNum();
        if (rows > 0) {
            HashMap<String, Integer> cellMap = new HashMap<String, Integer>();
            Row heard = sheet.getRow(0);
            for (int i = 0; i < heard.getPhysicalNumberOfCells(); ++i) {
                Cell cell = heard.getCell(i);
                if (StringUtil.isNotNull((Object)cell)) {
                    String value = this.getCellValue(heard, i).toString();
                    cellMap.put(value, i);
                    continue;
                }
                cellMap.put(null, i);
            }
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (int col = 0; col < allFields.length; ++col) {
                Field field = allFields[col];
                Excel attr = field.getAnnotation(Excel.class);
                if (attr == null || attr.type() != Excel.Type.ALL && attr.type() != this.type) continue;
                field.setAccessible(true);
                Integer column = (Integer)cellMap.get(attr.name());
                if (column == null) continue;
                fieldsMap.put(column, field);
            }
            for (int i = 1; i <= rows; ++i) {
                Row row = sheet.getRow(i);
                if (this.isRowEmpty(row)) continue;
                Object entity = null;
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    boolean isMerge = ExcelTool.isMergedRegion(sheet, i, (Integer)entry.getKey());
                    Object val = null;
                    val = isMerge ? this.getMergedCellValue(sheet, i, (Integer)entry.getKey()) : this.getCellValue(row, (Integer)entry.getKey());
                    entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                    Field field = (Field)fieldsMap.get(entry.getKey());
                    Class<?> fieldType = field.getType();
                    if (String.class == fieldType) {
                        String dateFormat;
                        String s = Convert.toStr((Object)val);
                        val = StringUtil.endsWith((CharSequence)s, (CharSequence)".0") ? StringUtil.substringBefore((String)s, (String)".0") : (StringUtil.isNotEmpty((String)(dateFormat = field.getAnnotation(Excel.class).dateFormat())) ? DateUtils.parseDateToStr((String)dateFormat, (Date)((Date)val)) : Convert.toStr((Object)val));
                    } else if ((Integer.TYPE == fieldType || Integer.class == fieldType) && StringUtil.isNumeric((CharSequence)Convert.toStr((Object)val))) {
                        val = Convert.toInt((Object)val);
                    } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                        val = Convert.toLong((Object)val);
                    } else if (Double.TYPE == fieldType || Double.class == fieldType) {
                        val = Convert.toDouble((Object)val);
                    } else if (Float.TYPE == fieldType || Float.class == fieldType) {
                        val = Convert.toFloat((Object)val);
                    } else if (BigDecimal.class == fieldType) {
                        val = Convert.toBigDecimal((Object)val);
                    } else if (Date.class == fieldType) {
                        if (val instanceof String) {
                            val = DateUtils.parseDate((Object)val);
                        } else if (val instanceof Double) {
                            val = DateUtil.getJavaDate((double)((Double)val));
                        }
                    } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                        val = Convert.toBool((Object)val, (Boolean)false);
                    }
                    if (!StringUtil.isNotNull(fieldType)) continue;
                    Excel attr = field.getAnnotation(Excel.class);
                    String propertyName = field.getName();
                    if (StringUtil.isNotEmpty((String)attr.targetAttr())) {
                        propertyName = field.getName() + "." + attr.targetAttr();
                    } else if (StringUtil.isNotEmpty((String)attr.readConverterExp())) {
                        val = ExcelTool.reverseByExp(Convert.toStr((Object)val), attr.readConverterExp(), attr.separator());
                    }
                    ReflectUtils.invokeSetter(entity, propertyName, val);
                }
                if (entity == null) continue;
                list.add(entity);
            }
        }
        return list;
    }

    public List<T> importExcel(String sheetName, InputStream is, Integer headRowNum, Integer rowNum) throws Exception {
        this.type = Excel.Type.IMPORT;
        this.wb = WorkbookFactory.create((InputStream)is);
        ArrayList<Object> list = new ArrayList<Object>();
        Sheet sheet = null;
        sheet = StringUtil.isNotEmpty((String)sheetName) ? this.wb.getSheet(sheetName) : this.wb.getSheetAt(0);
        if (sheet == null) {
            throw new IOException("\u6587\u4ef6sheet\u4e0d\u5b58\u5728");
        }
        int rows = sheet.getLastRowNum();
        if (rows > 0) {
            HashMap<String, Integer> cellMap = new HashMap<String, Integer>();
            int head = headRowNum - 1;
            Row heard = sheet.getRow(head);
            for (int i = 0; i < heard.getPhysicalNumberOfCells(); ++i) {
                Cell cell = heard.getCell(i);
                if (StringUtil.isNotNull((Object)cell)) {
                    String value = this.getCellValue(heard, i).toString();
                    cellMap.put(value, i);
                    continue;
                }
                cellMap.put(null, i);
            }
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (int col = 0; col < allFields.length; ++col) {
                Field field = allFields[col];
                Excel attr = field.getAnnotation(Excel.class);
                if (attr == null || attr.type() != Excel.Type.ALL && attr.type() != this.type) continue;
                field.setAccessible(true);
                Integer column = (Integer)cellMap.get(attr.name());
                if (column == null) continue;
                fieldsMap.put(column, field);
            }
            for (int i = rowNum - 1; i <= rows; ++i) {
                Row row = sheet.getRow(i);
                if (this.isRowEmpty(row)) continue;
                Object entity = null;
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    boolean isMerge = ExcelTool.isMergedRegion(sheet, i, (Integer)entry.getKey());
                    Object val = null;
                    val = isMerge ? this.getMergedCellValue(sheet, i, (Integer)entry.getKey()) : this.getCellValue(row, (Integer)entry.getKey());
                    entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                    Field field = (Field)fieldsMap.get(entry.getKey());
                    Class<?> fieldType = field.getType();
                    if (String.class == fieldType) {
                        String dateFormat;
                        String s = Convert.toStr((Object)val);
                        val = StringUtil.endsWith((CharSequence)s, (CharSequence)".0") ? StringUtil.substringBefore((String)s, (String)".0") : (StringUtil.isNotEmpty((String)(dateFormat = field.getAnnotation(Excel.class).dateFormat())) ? DateUtils.parseDateToStr((String)dateFormat, (Date)((Date)val)) : Convert.toStr((Object)val));
                    } else if ((Integer.TYPE == fieldType || Integer.class == fieldType) && StringUtil.isNumeric((CharSequence)Convert.toStr((Object)val))) {
                        val = Convert.toInt((Object)val);
                    } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                        val = Convert.toLong((Object)val);
                    } else if (Double.TYPE == fieldType || Double.class == fieldType) {
                        val = Convert.toDouble((Object)val);
                    } else if (Float.TYPE == fieldType || Float.class == fieldType) {
                        val = Convert.toFloat((Object)val);
                    } else if (BigDecimal.class == fieldType) {
                        val = Convert.toBigDecimal((Object)val);
                    } else if (Date.class == fieldType) {
                        if (val instanceof String) {
                            val = DateUtils.parseDate((Object)val);
                        } else if (val instanceof Double) {
                            val = DateUtil.getJavaDate((double)((Double)val));
                        }
                    } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                        val = Convert.toBool((Object)val, (Boolean)false);
                    }
                    if (!StringUtil.isNotNull(fieldType)) continue;
                    Excel attr = field.getAnnotation(Excel.class);
                    String propertyName = field.getName();
                    if (StringUtil.isNotEmpty((String)attr.targetAttr())) {
                        propertyName = field.getName() + "." + attr.targetAttr();
                    } else if (StringUtil.isNotEmpty((String)attr.readConverterExp())) {
                        val = ExcelTool.reverseByExp(Convert.toStr((Object)val), attr.readConverterExp(), attr.separator());
                    }
                    ReflectUtils.invokeSetter(entity, propertyName, val);
                }
                if (entity == null) continue;
                list.add(entity);
            }
        }
        return list;
    }

    public void exportExcel(HttpServletResponse response, List<T> list, String sheetName) throws IOException {
        String filedisplay = URLEncoder.encode(sheetName + ".xlsx", "utf-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        this.init(list, sheetName, Excel.Type.EXPORT);
        this.exportExcel((OutputStream)response.getOutputStream());
    }

    public void importTemplateExcel(HttpServletResponse response, String sheetName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        this.init(null, sheetName, Excel.Type.IMPORT);
        this.exportExcel((OutputStream)response.getOutputStream());
    }

    public void exportExcel(OutputStream out) {
        try {
            this.writeSheet();
            this.wb.write(out);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.wb);
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    public void writeSheet() {
        double sheetNo = Math.ceil(this.list.size() / 65536);
        int index = 0;
        while ((double)index <= sheetNo) {
            this.createSheet(sheetNo, index);
            Row row = this.sheet.createRow(0);
            int column = 0;
            for (Object[] os : this.fields) {
                Excel excel = (Excel)os[1];
                this.createCell(excel, row, column++);
            }
            if (Excel.Type.EXPORT.equals((Object)this.type)) {
                this.fillExcelData(index, row);
                this.addStatisticsRow();
            }
            ++index;
        }
    }

    public void fillExcelData(int index, Row row) {
        int startNo = index * 65536;
        int endNo = Math.min(startNo + 65536, this.list.size());
        for (int i = startNo; i < endNo; ++i) {
            row = this.sheet.createRow(i + 1 - startNo);
            T vo = this.list.get(i);
            int column = 0;
            for (Object[] os : this.fields) {
                Field field = (Field)os[0];
                Excel excel = (Excel)os[1];
                field.setAccessible(true);
                this.addCell(excel, row, vo, field, column++);
            }
        }
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font totalFont = wb.createFont();
        totalFont.setFontName("Arial");
        totalFont.setFontHeightInPoints((short)10);
        style.setFont(totalFont);
        styles.put("total", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.LEFT);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.RIGHT);
        styles.put("data3", style);
        return styles;
    }

    public Cell createCell(Excel attr, Row row, int column) {
        Cell cell = row.createCell(column);
        cell.setCellValue(attr.name());
        this.setDataValidation(attr, row, column);
        cell.setCellStyle(this.styles.get("header"));
        return cell;
    }

    public void setCellVo(Object value, Excel attr, Cell cell) {
        if (Excel.ColumnType.STRING == attr.cellType()) {
            cell.setCellValue(StringUtil.isNull((Object)value) ? attr.defaultValue() : value + attr.suffix());
        } else if (Excel.ColumnType.NUMERIC == attr.cellType()) {
            if (StringUtil.isNotNull((Object)value)) {
                cell.setCellValue(StringUtil.contains((String)Convert.toStr((Object)value), (String)".") ? Convert.toDouble((Object)value) : (double)Convert.toInt((Object)value).intValue());
            }
        } else if (Excel.ColumnType.IMAGE == attr.cellType()) {
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), cell.getRow().getRowNum(), (int)((short)(cell.getColumnIndex() + 1)), cell.getRow().getRowNum() + 1);
            String imagePath = Convert.toStr((Object)value);
            if (StringUtil.isNotEmpty((String)imagePath)) {
                byte[] data = ImageUtils.getImage(imagePath);
                ExcelTool.getDrawingPatriarch(cell.getSheet()).createPicture((ClientAnchor)anchor, cell.getSheet().getWorkbook().addPicture(data, this.getImageType(data)));
            }
        }
    }

    public static Drawing<?> getDrawingPatriarch(Sheet sheet) {
        if (sheet.getDrawingPatriarch() == null) {
            sheet.createDrawingPatriarch();
        }
        return sheet.getDrawingPatriarch();
    }

    public int getImageType(byte[] value) {
        String type = FileTypeUtils.getFileExtendName((byte[])value);
        if ("JPG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        return 5;
    }

    public void setDataValidation(Excel attr, Row row, int column) {
        if (attr.name().indexOf("\u6ce8\uff1a") >= 0) {
            this.sheet.setColumnWidth(column, 6000);
        } else {
            this.sheet.setColumnWidth(column, (int)((attr.width() + 0.72) * 256.0));
        }
        if (StringUtil.isNotEmpty((String)attr.prompt())) {
            this.setXSSFPrompt(this.sheet, "", attr.prompt(), 1, 100, column, column);
        }
        if (attr.combo().length > 0) {
            this.setXSSFValidation(this.sheet, attr.combo(), 1, 100, column, column);
        }
    }

    public Cell addCell(Excel attr, Row row, T vo, Field field, int column) {
        Cell cell = null;
        try {
            row.setHeight(this.maxHeight);
            if (attr.isExport()) {
                cell = row.createCell(column);
                int align = attr.align().value();
                cell.setCellStyle(this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : "")));
                Object value = this.getTargetValue(vo, field, attr);
                String dateFormat = attr.dateFormat();
                String readConverterExp = attr.readConverterExp();
                String separator = attr.separator();
                if (StringUtil.isNotEmpty((String)dateFormat) && StringUtil.isNotNull((Object)value)) {
                    cell.setCellValue(DateUtils.parseDateToStr((String)dateFormat, (Date)((Date)value)));
                } else if (StringUtil.isNotEmpty((String)readConverterExp) && StringUtil.isNotNull((Object)value)) {
                    cell.setCellValue(ExcelTool.convertByExp(Convert.toStr((Object)value), readConverterExp, separator));
                } else if (value instanceof BigDecimal && -1 != attr.scale()) {
                    cell.setCellValue(((BigDecimal)value).setScale(attr.scale(), attr.roundingMode()).toString());
                } else {
                    this.setCellVo(value, attr, cell);
                }
                this.addStatisticsData(column, Convert.toStr((Object)value), attr);
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25{}", (Throwable)e);
        }
        return cell;
    }

    public void setXSSFPrompt(Sheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createCustomConstraint("DD1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidation dataValidation = helper.createValidation(constraint, regions);
        dataValidation.createPromptBox(promptTitle, promptContent);
        dataValidation.setShowPromptBox(true);
        sheet.addValidationData(dataValidation);
    }

    public void setXSSFValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions;
        DataValidationConstraint constraint;
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidation dataValidation = helper.createValidation(constraint = helper.createExplicitListConstraint(textlist), regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtil.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StringUtil.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String reverseByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtil.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[1].equals(value)) continue;
                    propertyString.append(itemArray[0] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[1].equals(propertyValue)) continue;
            return itemArray[0];
        }
        return StringUtil.stripEnd((String)propertyString.toString(), (String)separator);
    }

    private void addStatisticsData(Integer index, String text, Excel entity) {
        if (entity != null && entity.isStatistics()) {
            Double temp = 0.0;
            if (!this.statistics.containsKey(index)) {
                this.statistics.put(index, temp);
            }
            try {
                temp = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.statistics.put(index, this.statistics.get(index) + temp);
        }
    }

    public void addStatisticsRow() {
        if (this.statistics.size() > 0) {
            Cell cell = null;
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            Set<Integer> keys = this.statistics.keySet();
            cell = row.createCell(0);
            cell.setCellStyle(this.styles.get("total"));
            cell.setCellValue("\u5408\u8ba1");
            for (Integer key : keys) {
                cell = row.createCell(key.intValue());
                cell.setCellStyle(this.styles.get("total"));
                cell.setCellValue(DOUBLE_FORMAT.format(this.statistics.get(key)));
            }
            this.statistics.clear();
        }
    }

    private Object getTargetValue(T vo, Field field, Excel excel) throws Exception {
        Object o = field.get(vo);
        if (StringUtil.isNotEmpty((String)excel.targetAttr())) {
            String target = excel.targetAttr();
            if (target.indexOf(".") > -1) {
                String[] targets;
                for (String name : targets = target.split("[.]")) {
                    o = this.getValue(o, name);
                }
            } else {
                o = this.getValue(o, target);
            }
        }
        return o;
    }

    private Object getValue(Object o, String name) throws Exception {
        if (StringUtil.isNotNull((Object)o) && StringUtil.isNotEmpty((String)name)) {
            Class<?> clazz = o.getClass();
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            o = field.get(o);
        }
        return o;
    }

    private void createExcelField() {
        this.fields = new ArrayList<Object[]>();
        ArrayList<Field> tempFields = new ArrayList<Field>();
        tempFields.addAll(Arrays.asList(this.clazz.getSuperclass().getDeclaredFields()));
        tempFields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        for (Field field : tempFields) {
            Excel[] excels;
            if (field.isAnnotationPresent(Excel.class) && (CollectionUtils.isEmpty(this.selectedField) || this.selectedField.contains(field.getName()))) {
                this.putToField(field, field.getAnnotation(Excel.class));
            }
            if (!field.isAnnotationPresent(Excels.class)) continue;
            Excels attrs = field.getAnnotation(Excels.class);
            for (Excel excel : excels = attrs.value()) {
                this.putToField(field, excel);
            }
        }
        this.fields = this.fields.stream().sorted(Comparator.comparing(objects -> ((Excel)objects[1]).sort())).collect(Collectors.toList());
        this.maxHeight = this.getRowHeight();
    }

    public short getRowHeight() {
        double maxHeight = 0.0;
        for (Object[] os : this.fields) {
            Excel excel = (Excel)os[1];
            maxHeight = maxHeight > excel.height() ? maxHeight : excel.height();
        }
        return (short)(maxHeight * 20.0);
    }

    private void putToField(Field field, Excel attr) {
        if (attr != null && (attr.type() == Excel.Type.ALL || attr.type() == this.type)) {
            this.fields.add(new Object[]{field, attr});
        }
    }

    public void createWorkbook() {
        this.wb = new SXSSFWorkbook(500);
    }

    public void createSheet(double sheetNo, int index) {
        this.sheet = this.wb.createSheet();
        this.styles = this.createStyles(this.wb);
        if (sheetNo == 0.0) {
            this.wb.setSheetName(index, this.sheetName);
        } else {
            this.wb.setSheetName(index, this.sheetName + index);
        }
    }

    public Object getCellValue(Row row, int column) {
        if (row == null) {
            return row;
        }
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (StringUtil.isNotNull((Object)cell)) {
                if (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA) {
                    val = cell.getNumericCellValue();
                    val = DateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)((Double)val)) : ((Double)val % 1.0 != 0.0 ? new BigDecimal(val.toString()) : new DecimalFormat("0").format(val));
                } else if (cell.getCellType() == CellType.STRING) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == CellType.BOOLEAN) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == CellType.ERROR) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    private boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public Object getMergedCellValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            Object val = "";
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            try {
                Cell cell = fRow.getCell(firstColumn);
                if (StringUtil.isNotNull((Object)cell)) {
                    if (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA) {
                        val = cell.getNumericCellValue();
                        val = DateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)((Double)val)) : ((Double)val % 1.0 != 0.0 ? new BigDecimal(val.toString()) : new DecimalFormat("0").format(val));
                    } else if (cell.getCellType() == CellType.STRING) {
                        val = cell.getStringCellValue();
                    } else if (cell.getCellType() == CellType.BOOLEAN) {
                        val = cell.getBooleanCellValue();
                    } else if (cell.getCellType() == CellType.ERROR) {
                        val = cell.getErrorCellValue();
                    }
                }
            }
            catch (Exception e) {
                return val;
            }
            return val;
        }
        return null;
    }
}

