/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mongodb.page;

import com.artfess.mongodb.query.FieldSortMongo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long total = 0L;
    protected long size = 10L;
    protected long current = 1L;
    protected long pages = 1L;
    private List<T> rows;
    private List<FieldSortMongo> sorter = new ArrayList<FieldSortMongo>();

    public List<FieldSortMongo> getSorter() {
        return this.sorter;
    }

    public void setSorter(List<FieldSortMongo> sorter) {
        this.sorter = sorter;
    }

    public Page() {
        this.current = 1L;
        this.size = 10L;
    }

    public Page(int currentPage, int pageSize) {
        this.current = currentPage <= 0 ? 1L : (long)currentPage;
        this.size = pageSize <= 0 ? 1L : (long)pageSize;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long pageSize) {
        this.size = pageSize;
    }

    public long getCurrent() {
        return this.current;
    }

    public Page<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public Page<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public long getPages() {
        return this.pages;
    }

    public void build(List<T> rows) {
        this.setRows(rows);
        long count = this.getTotal();
        long divisor = count / this.getSize();
        long remainder = count % this.getSize();
        this.setPages(remainder == 0L ? (divisor == 0L ? 1L : divisor) : divisor + 1L);
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public static PageRequest getPageParam(Integer num, Integer size, Sort sort) {
        int pageNum = 0;
        if (Objects.nonNull(num) && num > 1) {
            pageNum = num - 1;
        }
        int pageSize = 10;
        if (Objects.nonNull(size) && size > 0) {
            pageSize = size;
        }
        return PageRequest.of((int)pageNum, (int)pageSize, (Sort)sort);
    }
}

