/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.persistence.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.consts.DingTalkConsts;
import com.artfess.integrate.model.WxUser;
import com.artfess.integrate.persistence.manager.IUserService;
import com.artfess.integrate.util.DingTalkHttpUtil;
import com.artfess.integrate.util.DingTalkTokenUtil;
import com.artfess.integrate.util.OrgConvertUtil;
import com.artfess.integrate.util.ThreadMessageUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiUserListbypageRequest;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.taobao.api.TaobaoRequest;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DtUserService
implements IUserService {
    @Resource
    UCFeignService uCFeignService;

    @Override
    public void create(ObjectNode user) throws IOException {
        String fullname = user.get("fullname").asText();
        WxUser wxUser = OrgConvertUtil.userToWxUser((JsonNode)user);
        if (BeanUtils.isEmpty((Object)wxUser.getDepartment())) {
            return;
        }
        String resultJson = null;
        resultJson = DingTalkHttpUtil.sendHttpsRequest(DingTalkConsts.getCreateUserUrl(), wxUser.toString(), "POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("dingtalkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60102".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("dingtalkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60104".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            String errmsg = result.get("errmsg").asText();
            String userid = errmsg.substring(errmsg.indexOf(":") + 1);
            userUnite.put("dingtalkId", userid);
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        String account = user.get("account").asText();
        ThreadMessageUtil.addMapMsg(fullname + "[" + account + "]", result.get("errmsg").asText());
    }

    public boolean queryUser(ObjectNode user) throws IOException {
        String account = user.get("account").asText();
        String getUserUrl = DingTalkConsts.getUserUrl() + account;
        String resultJsonUser = HttpUtil.sendHttpsRequest((String)getUserUrl, (String)"", (String)"GET");
        JsonNode userJson = JsonUtil.toJsonNode((String)resultJsonUser);
        return "0".equals(userJson.get("errcode").asText());
    }

    @Override
    public void update(ObjectNode user) throws IOException {
    }

    @Override
    public void delete(String userId) {
    }

    @Override
    public void deleteAll(String userIds) {
    }

    @Override
    public void addAll(JsonNode users) throws IOException {
        for (JsonNode user : users) {
            ObjectNode node = (ObjectNode)user;
            String mobile = user.get("mobile").asText();
            if ("null".equals(mobile) || StringUtil.isEmpty((String)mobile)) continue;
            this.create(node);
        }
    }

    @Override
    public void syncUser(String[] lAryId) throws IOException {
        ArrayNode userList = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)lAryId)) {
            for (int i = 0; i < lAryId.length; ++i) {
                ObjectNode user = (ObjectNode)this.uCFeignService.getUserById(lAryId[i]).getValue();
                if (user == null) continue;
                userList.add((JsonNode)user);
            }
        } else {
            userList = this.uCFeignService.getUsersNotYetSyncDingtalk();
        }
        this.addAll((JsonNode)userList);
    }

    public void pullOrgAndUser(String orgId) throws Exception {
        this.pullUserByDepartmentId(orgId);
        this.pullUser(orgId);
    }

    @Override
    public void pullUser(String pOrgId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getDepartmentListUrl());
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId(pOrgId);
        request.setFetchChild(Boolean.valueOf(false));
        request.setHttpMethod("GET");
        OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
        if (Long.valueOf(0L).equals(response.getErrcode())) {
            List departmentList = response.getDepartment();
            for (OapiDepartmentListResponse.Department o : departmentList) {
                String orgId = String.valueOf(o.getId());
                ObjectNode exist = this.uCFeignService.getOrgByIdOrCode(orgId);
                if (exist == null) {
                    exist = JsonUtil.getMapper().createObjectNode();
                    exist.put("id", o.getId());
                    exist.put("code", o.getId());
                    exist.put("name", o.getName());
                    exist.put("parentId", o.getParentid());
                    CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(exist);
                    if (!orgRsl.getState().booleanValue()) {
                        throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
                    }
                }
                this.pullUser(orgId);
                this.pullUserByDepartmentId(orgId);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u9489\u9489\u901a\u8baf\u5f55\u7684\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + response.getErrmsg());
        }
    }

    private void pullUserByDepartmentId(String orgId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getUsersByDepartmentId());
        OapiUserListbypageRequest request = new OapiUserListbypageRequest();
        Long offset = 0L;
        Long size = 100L;
        boolean hasNextData = true;
        while (hasNextData) {
            request.setDepartmentId(Long.valueOf(orgId));
            request.setHttpMethod("GET");
            request.setOffset(offset);
            request.setSize(size);
            request.setOrder("entry_desc");
            OapiUserListbypageResponse execute = (OapiUserListbypageResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
            List userlist = execute.getUserlist();
            if (userlist == null || userlist.size() == 0) {
                hasNextData = false;
            }
            if (BeanUtils.isNotEmpty((Object)userlist)) {
                for (OapiUserListbypageResponse.Userlist o : userlist) {
                    String mobile = o.getMobile();
                    if (!StringUtil.isNotEmpty((String)mobile)) continue;
                    CommonResult userexist = this.uCFeignService.getUserByMobile(mobile);
                    if (BeanUtils.isEmpty((Object)userexist) || !userexist.getState().booleanValue()) {
                        ObjectNode newUser = JsonUtil.getMapper().createObjectNode();
                        newUser.put("account", mobile);
                        newUser.put("mobile", mobile);
                        newUser.put("fullname", o.getName());
                        newUser.put("password", "123456");
                        JsonNode persistent = this.uCFeignService.addUserFromExterUni(newUser);
                        this.uCFeignService.addUsersForOrg(orgId, mobile);
                        ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
                        userUnite.set("userId", persistent.get("id"));
                        userUnite.put("dingtalkId", o.getUserid());
                        this.uCFeignService.updateUserUnite(userUnite);
                        continue;
                    }
                    ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
                    userUnite.set("userId", ((JsonNode)userexist.getValue()).get("id"));
                    userUnite.put("dingtalkId", o.getUserid());
                    this.uCFeignService.updateUserUnite(userUnite);
                }
            }
            Long l = offset;
            Long l2 = offset = Long.valueOf(offset + 1L);
        }
    }
}

