/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.execution.sign.service;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.constant.PrivilegeMode;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.PrivilegeItem;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.api.service.SignService;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.artfess.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
implements SignService {
    @Resource
    private BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    private IUserGroupService defaultUserGroupService;
    @Resource
    private IUserService userServiceImpl;
    @Resource
    private BpmTaskManager bpmTaskManager;
    @Resource
    NotifyHelper notifyHelper;

    @Override
    public ResultMessage addSignTask(String taskId, String[] aryUsers) throws Exception {
        return this.bpmTaskManager.addSignTask(taskId, aryUsers);
    }

    private boolean containGroup(List<IGroup> groups, String groupId) {
        for (IGroup group : groups) {
            if (!group.getGroupId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    private void after(List<PrivilegeMode> privilegeModes) {
        boolean hasAll = false;
        for (PrivilegeMode mode : privilegeModes) {
            if (!mode.equals((Object)PrivilegeMode.ALL)) continue;
            hasAll = true;
            break;
        }
        if (hasAll) {
            privilegeModes.clear();
            privilegeModes.add(PrivilegeMode.ALL);
        }
    }

    @Override
    public List<PrivilegeMode> getPrivilege(String userId, SignNodeDef signNodeDef, Map<String, Object> variables) throws Exception {
        List<PrivilegeItem> privilegeList = signNodeDef.getPrivilegeList();
        ArrayList<PrivilegeMode> privilegeModes = new ArrayList<PrivilegeMode>();
        if (BeanUtils.isEmpty(privilegeList)) {
            return privilegeModes;
        }
        BpmUserCalcPluginSession pluginSession = this.bpmPluginSessionFactory.buildBpmUserCalcPluginSession(variables);
        List groups = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        block0: for (PrivilegeItem item : privilegeList) {
            List<BpmIdentity> bpmIdentities = UserAssignRuleQueryHelper.query(item.getUserRuleList(), pluginSession);
            for (BpmIdentity bpmIdentity : bpmIdentities) {
                if (!BeanUtils.isNotEmpty((Object)bpmIdentity)) continue;
                if (bpmIdentity.getType().equals("user") && bpmIdentity.getId().equals(userId)) {
                    privilegeModes.add(item.getPrivilegeMode());
                    continue block0;
                }
                if (bpmIdentity.getType().equals("group") && this.containGroup(groups, bpmIdentity.getId())) {
                    privilegeModes.add(item.getPrivilegeMode());
                    continue block0;
                }
                if (!bpmIdentity.getType().equals("groupUser") || bpmIdentity.getId().indexOf(userId) <= 0) continue;
                privilegeModes.add(item.getPrivilegeMode());
                continue block0;
            }
        }
        this.after(privilegeModes);
        return privilegeModes;
    }

    @Override
    public void sendNotify(List<IUser> receiverUsers, List<String> msgTypeKeys, String typeKey, Map<String, Object> vars) throws Exception {
        this.notifyHelper.notify(receiverUsers, msgTypeKeys, typeKey, vars);
    }

    @Override
    public ResultMessage addCustomSignTask(String taskId, String[] aryUsers) throws Exception {
        return this.bpmTaskManager.addCustomSignTask(taskId, aryUsers);
    }
}

