/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ButtonsBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<Button>> {
    private String getXml(List<Button> buttons) {
        String xml = "";
        if (BeanUtils.isEmpty(buttons)) {
            return "";
        }
        try {
            XMLBuilder ruleBuilder = XMLBuilder.create((String)"ext:buttons");
            ruleBuilder.a("xmlns:ext", "http://www.jee-soft.cn/bpm");
            Boolean isFalg = false;
            for (Button btn : buttons) {
                if (!"lockUnlock".equals(btn.getAlias()) || !btn.getIsLock().booleanValue()) continue;
                isFalg = true;
                break;
            }
            for (Button btn : buttons) {
                String isLock = "false";
                if (isFalg.booleanValue()) {
                    isLock = "true";
                }
                XMLBuilder build = ruleBuilder.e("ext:button").a("name", btn.getName()).a("alias", btn.getAlias()).a("isLock", isLock);
                if (BeanUtils.isNotEmpty((Object)btn.getBeforeScript())) {
                    build.e("ext:beforeScript").d(btn.getBeforeScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getAfterScript())) {
                    build.e("ext:afterScript").d(btn.getAfterScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getGroovyScript())) {
                    build.e("ext:groovyScript").d(btn.getGroovyScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getRejectMode())) {
                    build.e("ext:rejectMode").d(btn.getRejectMode());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getCompleteEventGroovyScript())) {
                    build.e("ext:completeEventGroovyScript").d(btn.getCompleteEventGroovyScript());
                }
                ruleBuilder.up();
            }
            xml = ruleBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    public static void main(String[] args) {
    }

    @Override
    protected String getXml(String defId, String nodeId, List<Button> buttons) {
        String xml = this.getXml(buttons);
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:buttons";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
        return rtnXml;
    }
}

