/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.core.cmd;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.artfess.bpm.api.plugin.core.context.BpmPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.plugin.core.session.DefaultBpmExecutionPluginSession;
import java.util.List;
import javax.annotation.Resource;

public class PluginExecutionCommand
implements ExecutionCommand {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmPluginFactory bpmPluginFactory;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    BpmDefinitionService bpmDefinitionService;

    @Override
    public void execute(EventType eventType, BpmDelegateExecution execution) throws Exception {
        List<BpmPluginContext> nodePluginList;
        BpmNodeDef bpmNodeDef;
        String bpmnDefId = execution.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        BpmExecutionPluginSession bpmExecutionPluginSession = this.bpmPluginSessionFactory.buildBpmExecutionPluginSession(execution);
        ((DefaultBpmExecutionPluginSession)bpmExecutionPluginSession).setEventType(eventType);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                this.executeContext(bpmPluginContext, bpmExecutionPluginSession, eventType);
            }
        }
        if (StringUtil.isNotEmpty((String)execution.getNodeId()) && BeanUtils.isNotEmpty((Object)(bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, execution.getNodeId()))) && !bpmNodeDef.getType().equals((Object)NodeType.PARALLELGATEWAY) && BeanUtils.isNotEmpty(nodePluginList = bpmNodeDef.getBpmPluginContexts())) {
            for (BpmPluginContext bpmPluginContext : nodePluginList) {
                this.executeContext(bpmPluginContext, bpmExecutionPluginSession, eventType);
            }
        }
    }

    private void executeContext(BpmPluginContext bpmPluginContext, BpmExecutionPluginSession bpmExecutionPluginSession, EventType eventType) throws Exception {
        BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
        if (bpmPluginDef instanceof BpmExecutionPluginDef) {
            BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
            BpmExecutionPlugin bpmExecutionPlugin = this.bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
            if (bpmExecutionPlugin != null && bpmPluginContext.getEventTypes().contains((Object)eventType)) {
                bpmExecutionPlugin.execute(bpmExecutionPluginSession, bpmExecutionPluginDef);
            }
        }
    }
}

