/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.persistence.dao.ActTaskDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.ActHiTaskInstManager;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.persistence.model.ActHiTaskInst;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actTaskManager")
public class ActTaskManagerImpl
extends BaseManagerImpl<ActTaskDao, ActTask>
implements ActTaskManager {
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    ActHiTaskInstManager actHiTaskInstManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    @Transactional
    public ActTask createTask(String taskId, String userId) {
        String newTaskId = UniqueIdUtil.getSuid();
        String executionId = UniqueIdUtil.getSuid();
        ActTask actTask = (ActTask)super.get((Serializable)((Object)taskId));
        ActExecution actExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)actTask.getExecutionId()));
        ActHiTaskInst actHiTaskInst = (ActHiTaskInst)this.actHiTaskInstManager.get((Serializable)((Object)taskId));
        DefaultBpmTask defaultBpmTask = this.bpmTaskManager.getByRelateTaskId(taskId);
        ActTask newActTask = (ActTask)actTask.clone();
        newActTask.setId(newTaskId);
        newActTask.setExecutionId(executionId);
        newActTask.setAssignee(userId);
        newActTask.setOwner(userId);
        ActExecution newActExecution = (ActExecution)actExecution.clone();
        newActExecution.setId(executionId);
        ActHiTaskInst newActHiTask = null;
        if (BeanUtils.isNotEmpty((Object)actHiTaskInst)) {
            newActHiTask = (ActHiTaskInst)actHiTaskInst.clone();
            newActHiTask.setId(newTaskId);
            newActHiTask.setExecutionId(executionId);
            newActHiTask.setAssignee(userId);
            newActHiTask.setOwner(userId);
        }
        DefaultBpmTask newBpmTask = (DefaultBpmTask)defaultBpmTask.clone();
        try {
            IUser userById = ServiceUtil.getUserById(userId);
            newBpmTask.setAssigneeName(userById.getFullname());
            newBpmTask.setOwnerName(userById.getFullname());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newBpmTask.setId(newTaskId);
        newBpmTask.setTaskId(newTaskId);
        newBpmTask.setExecId(executionId);
        newBpmTask.setAssigneeId(userId);
        newBpmTask.setOwnerId(userId);
        this.actExecutionManager.create((Model)newActExecution);
        super.create((Model)newActTask);
        if (BeanUtils.isNotEmpty((Object)newActHiTask)) {
            this.actHiTaskInstManager.create((Model)newActHiTask);
        }
        this.bpmTaskManager.create((Model)newBpmTask);
        return newActTask;
    }

    @Override
    @Transactional
    public ActTask createTask(ActExecution actExecution, BpmProcessInstance instance, BpmNodeDef bpmNodeDef) {
        ActTask actTask = this.createActTask(actExecution, bpmNodeDef, instance);
        this.createHiActTask(actTask);
        this.createBpmTask(actTask, instance);
        return actTask;
    }

    private ActTask createActTask(ActExecution actExecution, BpmNodeDef bpmNodeDef, BpmProcessInstance instance) {
        ActTask actTask = new ActTask();
        actTask.setId(UniqueIdUtil.getSuid());
        actTask.setRev(1);
        actTask.setExecutionId(actExecution.getId());
        actTask.setProcInstId(actExecution.getProcInstId());
        actTask.setProcDefId(actExecution.getProcDefId());
        actTask.setName(bpmNodeDef.getName());
        actTask.setTaskDefKey(bpmNodeDef.getNodeId());
        actTask.setOwner(instance.getCreateBy());
        actTask.setAssignee(instance.getCreateBy());
        actTask.setPriority(50);
        actTask.setCreateTime(LocalDateTime.now());
        actTask.setSuspensionState(1);
        super.create((Model)actTask);
        return actTask;
    }

    private void createHiActTask(ActTask actTask) {
        ActHiTaskInst taskInst = new ActHiTaskInst();
        taskInst.setId(actTask.getId());
        taskInst.setProcDefId(actTask.getProcDefId());
        taskInst.setTaskDefKey(actTask.getTaskDefKey());
        taskInst.setProcInstId(actTask.getProcInstId());
        taskInst.setExecutionId(actTask.getExecutionId());
        taskInst.setName(actTask.getName());
        taskInst.setParentTaskId(actTask.getParentTaskId());
        taskInst.setOwner(actTask.getOwner());
        taskInst.setAssignee(actTask.getAssignee());
        taskInst.setStartTime(actTask.getCreateTime());
        taskInst.setPriority(actTask.getPriority());
        this.actHiTaskInstManager.create((Model)taskInst);
    }

    private void createBpmTask(ActTask actTask, BpmProcessInstance instance) {
        DefaultBpmTask bpmTask = new DefaultBpmTask();
        bpmTask.setId(actTask.getId());
        bpmTask.setName(actTask.getName());
        bpmTask.setSubject(instance.getSubject());
        bpmTask.setTaskId(actTask.getId());
        bpmTask.setExecId(actTask.getExecutionId());
        bpmTask.setNodeId(actTask.getTaskDefKey());
        bpmTask.setProcInstId(instance.getId());
        bpmTask.setProcDefId(instance.getProcDefId());
        bpmTask.setProcDefName(instance.getProcDefName());
        bpmTask.setOwnerId(actTask.getOwner());
        bpmTask.setAssigneeId(actTask.getAssignee());
        bpmTask.setSupportMobile(instance.getSupportMobile());
        bpmTask.setStatus(TaskType.NORMAL.name());
        bpmTask.setPriority(50L);
        bpmTask.setCreateTime(actTask.getCreateTime());
        bpmTask.setSuspendState((short)0);
        bpmTask.setBpmnInstId(actTask.getProcInstId());
        bpmTask.setBpmnDefId(actTask.getProcDefId());
        bpmTask.setTypeId(instance.getTypeId());
        bpmTask.setProcDefKey(instance.getProcDefKey());
        this.bpmTaskManager.create((Model)bpmTask);
    }

    @Override
    public List<ActTask> getByInstId(String actProcInstanceId) {
        return ((ActTaskDao)this.baseMapper).getByInstId(actProcInstanceId);
    }

    @Override
    public void removeByExecutionId(List<String> removeParentIds) {
        ((ActTaskDao)this.baseMapper).removeByExecutionId(removeParentIds);
    }
}

