/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.UpdateMethod;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.manager.OrgParamsManager;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.TenantTypeManager;
import com.artfess.uc.manager.UserParamsManager;
import com.artfess.uc.model.OrgParams;
import com.artfess.uc.model.Params;
import com.artfess.uc.model.UserParams;
import com.artfess.uc.params.params.ParamVo;
import com.artfess.uc.util.OrgUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/params/v1/"})
@Api(tags={"\u7528\u6237\u7ec4\u7ec7\u53c2\u6570"})
@ApiGroup(group={"group_uc"})
public class ParamsController
extends BaseController<ParamsManager, Params> {
    @Resource
    ParamsManager paramsService;
    @Resource
    UserParamsManager userParamsService;
    @Resource
    OrgParamsManager orgParamsService;
    @Resource
    TenantTypeManager tenantTypeManager;

    @RequestMapping(value={"params/getParamsPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53c2\u6570\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u53c2\u6570\u5217\u8868")
    public PageList<Params> getParamsPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        boolean isTenant = false;
        List querys = filter.getQuerys();
        for (QueryField qfield : querys) {
            if (!"TYPE_".equals(qfield.getProperty()) || !"3".equals(qfield.getValue())) continue;
            isTenant = true;
            break;
        }
        filter.addFilter("is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        PageList query = isTenant ? this.paramsService.queryWithType(filter) : this.paramsService.query(filter);
        return query;
    }

    @RequestMapping(value={"userParams/getUserParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u53c2\u6570\u5217\u8868")
    public List<Params> getUserParams() throws Exception {
        return this.paramsService.getByType("1");
    }

    @RequestMapping(value={"orgParams/getOrgParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u7684\u53c2\u6570\u5217\u8868")
    public List<Params> getOrgParams() throws Exception {
        return this.paramsService.getByType("2");
    }

    @RequestMapping(value={"param/addParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u53c2\u6570", httpMethod="POST", notes="\u6dfb\u52a0\u53c2\u6570")
    public CommonResult<String> addParams(@ApiParam(name="param", value="\u53c2\u6570\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ParamVo param) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.paramsService.addParams(param);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"");
        }
        return rtn;
    }

    @RequestMapping(value={"param/deleteParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u5220\u9664\u53c2\u6570", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u53c2\u6570")
    public CommonResult<String> deleteParams(@ApiParam(name="codes", value="\u53c2\u6570\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.paramsService.deleteParams(codes);
    }

    @RequestMapping(value={"param/deleteParamsByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570id\u5220\u9664\u53c2\u6570", httpMethod="DELETE", notes="\u6839\u636eid\u5220\u9664\u53c2\u6570")
    public CommonResult<String> deleteParamsByIds(@ApiParam(name="ids", value="\u53c2\u6570id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        return this.paramsService.deleteParamsByIds(ids);
    }

    @RequestMapping(value={"param/updateParams"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u53c2\u6570\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0", httpMethod="PUT", notes="\u66f4\u65b0\u53c2\u6570\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0")
    @UpdateMethod(type=ParamVo.class)
    public CommonResult<String> updateParams(@ApiParam(name="param", value="\u53c2\u6570\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ParamVo param) throws Exception {
        return this.paramsService.updateParams(param);
    }

    @RequestMapping(value={"param/getParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u3001\u79df\u6237\u7c7b\u578b\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u53c2\u6570\u4fe1\u606f")
    public Params getParams(@ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="tenantTypeId", value="\u79df\u6237\u7c7b\u578b", required=true) @RequestParam String tenantTypeId) throws Exception {
        return this.paramsService.getByTeam(code, tenantTypeId);
    }

    @RequestMapping(value={"param/getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u53c2\u6570\u4fe1\u606f")
    public Params getByAlias(@ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsService.getByAlias(code);
    }

    @RequestMapping(value={"userParam/getUserParamsByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570")
    public UserParams getUserParamsByCode(@ApiParam(name="account", value="\u7528\u6237\u8d26\u6237", required=true) @RequestParam String account, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsService.getUserParamsByCode(account, code);
    }

    @RequestMapping(value={"userParam/getUserParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570")
    public UserParams getUserParamsById(@ApiParam(name="userId", value="\u7528\u6237ID", required=true) @RequestParam String userId, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsService.getUserParamsById(userId, code);
    }

    @RequestMapping(value={"orgParam/getOrgParamsByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570")
    public OrgParams getOrgParamsByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsService.getOrgParamsByCode(orgCode, code);
    }

    @RequestMapping(value={"orgParam/getOrgParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570")
    public OrgParams getOrgParamsById(@ApiParam(name="orgId", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgId, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsService.getOrgParamsById(orgId, code);
    }

    @RequestMapping(value={"Param/deleteParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570")
    public CommonResult<Integer> deleteParamPhysical() throws Exception {
        Integer num = this.paramsService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"userParam/deleteUserParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteUserParamPhysical() throws Exception {
        Integer num = this.userParamsService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"orgParam/deleteOrgParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteOrgParamPhysical() throws Exception {
        Integer num = this.orgParamsService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"params/getParamsByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<Params> getParamsByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        return this.paramsService.getParamsByTime(btime, etime);
    }

    @RequestMapping(value={"params/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.paramsService.isCodeExist(code);
    }

    @RequestMapping(value={"tenantParams/getTenantParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u7c7b\u578b\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u79df\u6237\u7c7b\u578b\u7684\u53c2\u6570\u5217\u8868")
    public List<Params> getTenantParams(@ApiParam(name="tenantTypeId", value="\u79df\u6237\u7c7b\u578bid") @RequestParam(required=true) String tenantTypeId) throws Exception {
        return this.paramsService.getByTenantTypeId(tenantTypeId);
    }
}

