/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.service.impl;

import com.artfess.base.service.LoginLogService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.LoginLogManager;
import com.artfess.uc.model.LoginLog;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Primary
@Service
public class LoginLogServiceImpl
implements LoginLogService {
    protected static Logger logger = LoggerFactory.getLogger(LoginLogServiceImpl.class);
    @Resource
    LoginLogManager loginLogManager;
    @Resource
    UserDetailsService userDetailsService;

    public void log(String account, String loginType) {
        try {
            HttpServletRequest request = HttpUtil.getRequest();
            LoginLog log = this.loginLogManager.getByAccount(account);
            String ip = WebUtil.getIpAddr((HttpServletRequest)request);
            if (BeanUtils.isEmpty((Object)log)) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                if (BeanUtils.isNotEmpty((Object)userDetails)) {
                    IUser user = (IUser)userDetails;
                    log = new LoginLog();
                    log.setAccount(account);
                    log.setName(user.getFullname());
                    log.setId(user.getUserId());
                    log.setLoginSum(1);
                    if ("mobile".equals(loginType)) {
                        log.setMobileSum(log.getMobileSum() + 1);
                    } else {
                        log.setPcSum(log.getPcSum() + 1);
                    }
                    log.setIp(ip);
                    log.setLoginType(loginType);
                    this.loginLogManager.create((Model)log);
                }
            } else {
                if ("mobile".equals(loginType)) {
                    log.setMobileSum(log.getMobileSum() + 1);
                } else {
                    log.setPcSum(log.getPcSum() + 1);
                }
                log.setLoginSum(log.getLoginSum() + 1);
                log.setIp(ip);
                log.setLoginType(loginType);
                this.loginLogManager.update((Model)log);
            }
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u7528\u6237\u767b\u5f55\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

