/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.OrgPostDao;
import com.artfess.uc.dao.OrgUserDao;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class OrgPostManagerImpl
extends BaseManagerImpl<OrgPostDao, OrgPost>
implements OrgPostManager {
    @Resource
    OrgUserDao orgUserDao;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    OrgManager orgService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    private BaseContext baseContext;

    @Override
    public OrgPost getByCode(String code) {
        return ((OrgPostDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<OrgPost> getListByOrgId(String orgId) {
        return ((OrgPostDao)this.baseMapper).getListByOrgId(orgId);
    }

    @Override
    public List<OrgPost> queryInfoList(QueryFilter queryFilter) {
        return ((OrgPostDao)this.baseMapper).queryInfoList(queryFilter);
    }

    @Override
    public OrgPost getByOrgIdRelDefId(String orgId, String relDefId) {
        return ((OrgPostDao)this.baseMapper).getByOrgIdRelDefId(orgId, relDefId);
    }

    @Override
    public List<OrgPost> getListByUserId(String userId, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        if (StringUtil.isNotEmpty((String)demId)) {
            map.put("demId", demId);
        }
        return ((OrgPostDao)this.baseMapper).getRelListByParam(map);
    }

    @Override
    public List<OrgPost> getListByAccount(String account, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", account);
        map.put("demId", demId);
        List<OrgPost> orgPosts = ((OrgPostDao)this.baseMapper).getRelListByParam(map);
        for (OrgPost orgPost : orgPosts) {
            Org org = (Org)this.orgService.get((Serializable)((Object)orgPost.getOrgId()));
            if (BeanUtils.isNotEmpty((Object)org)) {
                orgPost.setOrgName(org.getName());
                Demension dem = (Demension)this.demensionService.get((Serializable)((Object)org.getDemId()));
                if (BeanUtils.isNotEmpty((Object)dem)) {
                    orgPost.setDemName(dem.getDemName());
                }
            }
            OrgJob orgJob = (OrgJob)this.orgJobService.get((Serializable)((Object)orgPost.getRelDefId()));
            String postLevel = orgJob.getPostLevel();
            if (!BeanUtils.isNotEmpty((Object)orgJob)) continue;
            orgPost.setJobName(orgJob.getName());
            orgPost.setPostLevel(postLevel);
        }
        return orgPosts;
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            OrgPost rel = this.get((Serializable)((Object)id));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgId", rel.getOrgId());
            List<OrgUser> orgUserList = this.orgUserDao.getByParms(map);
            if (BeanUtils.isNotEmpty(orgUserList)) {
                this.removeOrgUser(rel, orgUserList);
                continue;
            }
            this.remove((Serializable)((Object)rel.getId()));
        }
    }

    @Transactional
    public void removeOrgUser(OrgPost rel, List<OrgUser> orgUserList) {
        for (OrgUser user : orgUserList) {
            OrgUser orgUser;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgId", rel.getOrgId());
            params.put("userId", user.getUserId());
            List<OrgUser> list = this.orgUserDao.getByParms(params);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", user.getUserId());
            map.put("relId", rel.getId());
            if (list.size() == 1 && rel.getId().equals(list.get(0).getRelId())) {
                orgUser = this.orgUserDao.getByParms(map).get(0);
                orgUser.setRelId(null);
                this.orgUserService.update((Model)orgUser);
            } else if (list.size() > 1 && BeanUtils.isNotEmpty(this.orgUserDao.getByParms(map))) {
                orgUser = this.orgUserDao.getByParms(map).get(0);
                this.orgUserService.remove((Serializable)((Object)orgUser.getId()));
            }
            this.remove((Serializable)((Object)rel.getId()));
        }
    }

    @Override
    public List<OrgPost> getByRelDefId(String relDefId) {
        return ((OrgPostDao)this.baseMapper).getByReldefId(relDefId);
    }

    @Override
    @Transactional
    public boolean setRelCharge(String id, boolean isCharge) {
        int charge = isCharge ? 1 : 0;
        ((OrgPostDao)this.baseMapper).updateRelCharge(id, charge, LocalDateTime.now());
        return true;
    }

    @Override
    @Transactional
    public boolean cancelRelCharge(String orgId) {
        ((OrgPostDao)this.baseMapper).cancelRelCharge(orgId, LocalDateTime.now());
        return true;
    }

    @Override
    public List<OrgPost> getRelCharge(String orgId, Boolean isCharge) {
        if (BeanUtils.isEmpty((Object)isCharge)) {
            return ((OrgPostDao)this.baseMapper).getRelChargeByOrgId(orgId, null);
        }
        Integer charge = isCharge != false ? 1 : 0;
        return ((OrgPostDao)this.baseMapper).getRelChargeByOrgId(orgId, charge);
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((OrgPostDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public PageList<OrgPost> getOrgPost(QueryFilter filter) {
        PageBean pageBean = filter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        filter.addFilter("p.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        String currentOrgAddvcdFull = this.baseContext.getCurrentOrgAddvcdFull();
        filter.addFilter("o.path_", (Object)currentOrgAddvcdFull, QueryOP.LIKE);
        IPage<OrgPost> orgPost = ((OrgPostDao)this.baseMapper).getOrgPost((IPage<OrgPost>)page, (Wrapper<OrgPost>)this.convert2Wrapper(filter, this.currentModelClass()));
        return new PageList(orgPost);
    }

    @Override
    public List<Map<String, Object>> getFullname(String postId) {
        String currentOrgAddvcdFull = this.baseContext.getCurrentOrgAddvcdFull();
        return ((OrgPostDao)this.baseMapper).getFullname(postId, currentOrgAddvcdFull);
    }

    @Override
    public List<Map<String, Object>> getPostByJobId(String postId) {
        return ((OrgPostDao)this.baseMapper).getPostByJobId(postId);
    }

    @Override
    public List<Map<String, Object>> getUserByUserId(String userId) {
        List<Object> mapList = new ArrayList();
        mapList = ((OrgPostDao)this.baseMapper).getUserByUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Map<String, Object>> userJobByUserId = ((OrgPostDao)this.baseMapper).getUserJobByUserId(userId);
        ArrayList<String> roleNames = new ArrayList<String>();
        for (Map<String, Object> map2 : userJobByUserId) {
            roleNames.add(map2.get("roleName").toString());
        }
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("roleName", StringUtil.join(roleNames, (String)"|"));
        map.put("roleName", objectNode);
        map.put("roles", userJobByUserId);
        mapList.add(map);
        return mapList;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgPostDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<OrgPost> getByReldefId(String jobId) {
        return ((OrgPostDao)this.baseMapper).getByReldefId(jobId);
    }

    @Override
    public Integer getCountByCode(String code) {
        return ((OrgPostDao)this.baseMapper).getCountByCode(code);
    }

    public OrgPost get(Serializable id) {
        return ((OrgPostDao)this.baseMapper).get(id);
    }

    @Override
    public Map<String, Object> getSuperiorPost(String userId) {
        List<Map<String, Object>> list = ((OrgPostDao)this.baseMapper).getUserByUserId(userId);
        if (list.size() == 0) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u67e5\u65e0\u5c97\u4f4d");
        }
        Map<String, Object> post = null;
        if (list.size() == 1) {
            post = list.get(0);
        } else {
            for (Map<String, Object> map : list) {
                Object isMaster = map.get("isMaster");
                if (!BeanUtils.isNotEmpty((Object)isMaster) || (Integer)isMaster != 1) continue;
                post = map;
            }
        }
        if (post == null) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u65e0\u4e3b\u5c97\u4f4d\u6216\u975e\u4e3b\u5c97\u4f4d\u4e0d\u6b62\u4e00\u4e2a");
        }
        String parentId = (String)post.get("parentId");
        if (StringUtil.isEmpty((String)parentId)) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u65e0\u4e0a\u7ea7\u5c97\u4f4d");
        }
        OrgPost orgPost = this.get((Serializable)((Object)parentId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", orgPost.getCode());
        result.put("name", orgPost.getName());
        return result;
    }

    @Override
    public boolean insertBatch(List<OrgPost> list) {
        return this.saveBatch(list);
    }

    @Override
    public List<UserVo> findByPostIds(String postIds) {
        List<String> postIdList = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)postIds));
        return ((OrgPostDao)this.baseMapper).findByPostIds(postIdList);
    }
}

