/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.security.dao.SecurityPersonloginlimitDao;
import com.artfess.security.manager.SecurityPersonloginlimitManager;
import com.artfess.security.model.SecurityPersonloginlimit;
import com.artfess.security.vo.PersonloginlimitVo;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SecurityPersonloginlimitManagerImpl
extends BaseManagerImpl<SecurityPersonloginlimitDao, SecurityPersonloginlimit>
implements SecurityPersonloginlimitManager {
    @Autowired
    UserManager userManager;
    @Resource
    SecurityPersonloginlimitDao securityPersonloginlimitDao;

    @Override
    public IPage<PersonloginlimitVo> queryPersonloginlimitPage(QueryFilter<SecurityPersonloginlimit> queryFilter) throws Exception {
        queryFilter.getParams();
        queryFilter.addFilter("MACHINE_ID_", (Object)queryFilter.getParams().get("machineId").toString(), QueryOP.EQUAL);
        IPage<PersonloginlimitVo> pages = ((SecurityPersonloginlimitDao)this.baseMapper).queryLimitByMachine((IPage<SecurityPersonloginlimit>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SecurityPersonloginlimit>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return pages;
    }

    @Override
    @Transactional
    public CommonResult<String> insertPersonloginlimit(String machineId, String userIds) throws Exception {
        String[] idArray = userIds.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"MACHINE_ID_", (Object)machineId)).eq((Object)"USER_ID_", (Object)id);
            Integer count = this.securityPersonloginlimitDao.selectCount((Wrapper)queryWrapper);
            if (count > 0) continue;
            User user = (User)this.userManager.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)user)) {
                SecurityPersonloginlimit securityPersonloginlimit = new SecurityPersonloginlimit();
                securityPersonloginlimit.setMachineId(machineId);
                securityPersonloginlimit.setAccount(user.getAccount());
                securityPersonloginlimit.setUserId(id);
                this.create((Model)securityPersonloginlimit);
                continue;
            }
            isTrue = false;
            msg.append("\u5e10\u53f7\u3010" + id + "\u3011\u4e0d\u5b58\u5728\uff0c");
        }
        return new CommonResult(isTrue, BeanUtils.isEmpty((Object)msg) ? "\u5173\u8054\u6210\u529f\uff01" : msg.toString(), (Object)"");
    }

    @Override
    @Transactional
    public void deleteByMachineId(String machineId) throws Exception {
        Assert.hasText((String)machineId, (String)"\u6d89\u5bc6\u8ba1\u7b97\u673aID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"MACHINE_ID_", (Object)machineId);
        ((SecurityPersonloginlimitDao)this.baseMapper).delete((Wrapper)delWrapper);
    }
}

