/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.security.dao.BackupDatasourceDao;
import com.artfess.security.dao.BackupLogDao;
import com.artfess.security.manager.BackupDatasourceManager;
import com.artfess.security.model.BackupDatasource;
import com.artfess.security.model.BackupLog;
import com.artfess.security.util.SSHLinux;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupDatasourceManagerImpl
extends BaseManagerImpl<BackupDatasourceDao, BackupDatasource>
implements BackupDatasourceManager {
    @Autowired
    private BackupDatasourceDao mapper;
    @Autowired
    private BackupLogDao logMapper;

    @Override
    public String testDB(String id) {
        BackupDatasource BackupDatasource2 = (BackupDatasource)((Object)this.getById((Serializable)((Object)id)));
        try {
            boolean conn = this.checkConnection(BackupDatasource2.getDbUrl(), BackupDatasource2.getDbUser(), BackupDatasource2.getDbPwd(), BackupDatasource2.getDbDriver());
            if (conn) {
                return "\u8fde\u63a5\u6210\u529f\uff01";
            }
            return "\u8fde\u63a5\u5931\u8d25\uff01";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "\u8fde\u63a5\u5931\u8d25\uff01" + e.getMessage();
        }
    }

    @Override
    public String testSystem(String id) {
        BackupDatasource BackupDatasource2 = (BackupDatasource)((Object)this.getById((Serializable)((Object)id)));
        try {
            String conn = "";
            if ("linux".equals(BackupDatasource2.getSystemType())) {
                conn = SSHLinux.testConnect(BackupDatasource2.getSystemIp(), 22, BackupDatasource2.getSystemUser(), BackupDatasource2.getSystemPwd());
            }
            if (conn.indexOf("LSB Version") != -1) {
                return "\u8fde\u63a5\u6210\u529f\uff01";
            }
            return "\u8fde\u63a5\u5931\u8d25\uff01";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "\u8fde\u63a5\u5931\u8d25\uff01" + e.getMessage();
        }
    }

    @Override
    public String backUpDataBase(String id) {
        BackupDatasource BackupDatasource2 = (BackupDatasource)((Object)this.getById((Serializable)((Object)id)));
        Integer port = 22;
        String ip = BackupDatasource2.getSystemIp();
        String user = BackupDatasource2.getSystemUser();
        String pwd = BackupDatasource2.getSystemPwd();
        String cmd = BackupDatasource2.getBackupCommond();
        cmd = BackupDatasourceManagerImpl.getStrByCmd(cmd) + ".sql";
        String result = SSHLinux.exeCommand(ip, port, user, pwd, cmd);
        String file = cmd.substring(cmd.lastIndexOf(">") + 1).trim();
        this.saveLog(id, file, "\u5907\u4efd", result);
        return result;
    }

    @Override
    public String Reduction(String id) {
        BackupLog BackupLog2 = (BackupLog)((Object)this.logMapper.selectById((Serializable)((Object)id)));
        BackupDatasource BackupDatasource2 = (BackupDatasource)((Object)this.getById((Serializable)((Object)BackupLog2.getSystemConfigId())));
        Integer port = 22;
        String ip = BackupDatasource2.getSystemIp();
        String user = BackupDatasource2.getSystemUser();
        String pwd = BackupDatasource2.getSystemPwd();
        String cmd = BackupDatasource2.getReductionCommond();
        String file = BackupLog2.getBackupFile();
        cmd = cmd.substring(0, cmd.lastIndexOf("<")) + " < " + file;
        String result = SSHLinux.exeCommand(ip, port, user, pwd, cmd);
        this.saveLog(id, file, "\u8fd8\u539f", result);
        return result;
    }

    public void saveLog(String systemCopnfigId, String file, String type, String result) {
        BackupLog log = new BackupLog();
        log.setCreateTime(LocalDateTime.now());
        log.setSystemType(type);
        log.setSystemConfigId(systemCopnfigId);
        log.setBackupFile(file);
        log.setSystemResult(result);
        if ("\u8fd8\u539f".equals(type)) {
            log.setReductionTime(LocalDateTime.now());
            log.setReductionUserId(AuthenticationUtil.getCurrentUserId());
            log.setReductionOrgId(AuthenticationUtil.getCurrentUserMainOrgId());
            log.setReductionUser(AuthenticationUtil.getCurrentUsername());
        }
        this.logMapper.insert((Object)log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStrByCmd(String cmd) {
        Pattern p = Pattern.compile("\\{(.[^\\{\\}]*)\\}");
        Matcher m = p.matcher(cmd);
        StringBuffer sb = new StringBuffer();
        Matcher matcher = m;
        synchronized (matcher) {
            if (m.find()) {
                String dateFormat = m.group(1);
                m.appendReplacement(sb, BackupDatasourceManagerImpl.getDateFormat(dateFormat, new Date()));
            }
        }
        return sb.toString();
    }

    private static String getDateFormat(String dateFormat, Date date) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        return df.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(String url, String userName, String pwd, String driver) {
        boolean isConnection = false;
        Connection con = null;
        try {
            Class.forName(driver);
            System.out.println("\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u6210\u529f");
        }
        catch (ClassNotFoundException e) {
            this.log.error("\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25" + e.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, userName, pwd);
            isConnection = true;
            System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
        }
        catch (SQLException e) {
            this.log.error("\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    this.log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        return isConnection;
    }
}

